/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.schemas.Fields;
import com.datatorrent.lib.appdata.schemas.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    public static final String FIELD_TAGS = "tags";
    private static final Logger LOG = LoggerFactory.getLogger(SchemaUtils.class);

    private SchemaUtils() {
    }

    public static String jarResourceFileToString(String resource) {
        StringWriter stringWriter = new StringWriter();
        try {
            InputStream is = SchemaUtils.class.getClassLoader().getResourceAsStream(resource);
            Preconditions.checkArgument((is != null ? 1 : 0) != 0, (Object)(resource + " could not be found in the resources."));
            IOUtils.copy((InputStream)is, (Writer)stringWriter);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return stringWriter.toString();
    }

    public static String inputStreamToString(InputStream inputStream) {
        StringWriter stringWriter = new StringWriter();
        try {
            IOUtils.copy((InputStream)inputStream, (Writer)stringWriter);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return stringWriter.toString();
    }

    public static boolean checkValidKeys(JSONObject jo, Fields fields) {
        Set<String> fieldSet = fields.getFields();
        Set<String> jsonKeys = SchemaUtils.getSetOfJSONKeys(jo);
        return jsonKeys.containsAll(fieldSet);
    }

    public static void checkValidKeysEx(JSONObject jo, Fields fields) {
        Set<String> fieldSet = fields.getFields();
        Set<String> jsonKeys = SchemaUtils.getSetOfJSONKeys(jo);
        if (!jsonKeys.containsAll(fieldSet)) {
            throw new IllegalArgumentException("The given set of keys " + fieldSet + " doesn't equal the set of keys in the json " + jsonKeys);
        }
    }

    public static boolean checkValidKeys(JSONObject jo, Collection<Fields> fieldsCollection) {
        return SchemaUtils.checkValidKeysHelper(jo, fieldsCollection);
    }

    private static boolean checkValidKeysHelper(JSONObject jo, Collection<Fields> fieldsCollection) {
        for (Fields fields : fieldsCollection) {
            LOG.debug("Checking keys: {}", (Object)fields);
            if (!SchemaUtils.checkValidKeys(jo, fields)) continue;
            return true;
        }
        LOG.error("The first level of keys in the provided JSON {} do not match any of the valid keysets {}", SchemaUtils.getSetOfJSONKeys(jo), fieldsCollection);
        return false;
    }

    public static boolean checkValidKeys(JSONObject jo, List<Fields> fieldsCollection) {
        return SchemaUtils.checkValidKeysHelper(jo, fieldsCollection);
    }

    public static boolean checkValidKeysEx(JSONObject jo, Collection<Fields> fieldsCollection) {
        return SchemaUtils.checkValidKeysExHelper(jo, fieldsCollection);
    }

    public static boolean checkValidKeysExHelper(JSONObject jo, Collection<Fields> fieldsCollection) {
        for (Fields fields : fieldsCollection) {
            if (!SchemaUtils.checkValidKeys(jo, fields)) continue;
            return true;
        }
        Set<String> keys = SchemaUtils.getSetOfJSONKeys(jo);
        throw new IllegalArgumentException("The given json object has an invalid set of keys: " + keys + "\nOne of the following key combinations was expected:\n" + fieldsCollection);
    }

    public static boolean checkValidKeysEx(JSONObject jo, List<Fields> fieldsCollection) {
        return SchemaUtils.checkValidKeysExHelper(jo, fieldsCollection);
    }

    public static Set<String> getSetOfJSONKeys(JSONObject jo) {
        Iterator keyIterator = jo.keys();
        HashSet keySet = Sets.newHashSet();
        while (keyIterator.hasNext()) {
            keySet.add(keyIterator.next());
        }
        return keySet;
    }

    public static Map<String, String> convertFieldToType(Map<String, Type> fieldToType) {
        HashMap fieldToTypeString = Maps.newHashMap();
        for (Map.Entry<String, Type> entry : fieldToType.entrySet()) {
            String field = entry.getKey();
            String typeString = entry.getValue().name();
            fieldToTypeString.put(field, typeString);
        }
        return fieldToTypeString;
    }

    public static JSONArray findFirstKeyJSONArray(JSONObject jo, String key) {
        if (jo.has(key)) {
            try {
                JSONArray jsonArray = jo.getJSONArray(key);
                return jsonArray;
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
        Iterator keyIterator = jo.keys();
        while (keyIterator.hasNext()) {
            JSONArray result;
            String childKey = (String)keyIterator.next();
            JSONArray childJa = null;
            try {
                childJa = jo.getJSONArray(childKey);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (childJa != null) {
                JSONArray result2 = SchemaUtils.findFirstKeyJSONArray(childJa, key);
                if (result2 == null) continue;
                return result2;
            }
            JSONObject childJo = null;
            try {
                childJo = jo.getJSONObject(childKey);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (childJo == null || (result = SchemaUtils.findFirstKeyJSONArray(childJo, key)) == null) continue;
            return result;
        }
        return null;
    }

    public static JSONArray findFirstKeyJSONArray(JSONArray ja, String key) {
        for (int index = 0; index < ja.length(); ++index) {
            JSONArray result;
            JSONArray childJa = null;
            try {
                childJa = ja.getJSONArray(index);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (childJa != null) {
                JSONArray result2 = SchemaUtils.findFirstKeyJSONArray(childJa, key);
                if (result2 == null) continue;
                return result2;
            }
            JSONObject childJo = null;
            try {
                childJo = ja.getJSONObject(index);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (childJo == null || (result = SchemaUtils.findFirstKeyJSONArray(childJo, key)) == null) continue;
            return result;
        }
        return null;
    }

    public static JSONObject findFirstKeyJSONObject(JSONObject jo, String key) {
        if (jo.has(key)) {
            try {
                JSONObject jsonObject = jo.getJSONObject(key);
                return jsonObject;
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
        Iterator keyIterator = jo.keys();
        while (keyIterator.hasNext()) {
            JSONObject result;
            String childKey = (String)keyIterator.next();
            JSONArray childJa = null;
            try {
                childJa = jo.getJSONArray(childKey);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (childJa != null) {
                JSONObject result2 = SchemaUtils.findFirstKeyJSONObject(childJa, key);
                if (result2 == null) continue;
                return result2;
            }
            JSONObject childJo = null;
            try {
                childJo = jo.getJSONObject(childKey);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (childJo == null || (result = SchemaUtils.findFirstKeyJSONObject(childJo, key)) == null) continue;
            return result;
        }
        return null;
    }

    public static JSONObject findFirstKeyJSONObject(JSONArray ja, String key) {
        for (int index = 0; index < ja.length(); ++index) {
            JSONObject result;
            JSONArray childJa = null;
            try {
                childJa = ja.getJSONArray(index);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (childJa != null) {
                JSONObject result2 = SchemaUtils.findFirstKeyJSONObject(childJa, key);
                if (result2 == null) continue;
                return result2;
            }
            JSONObject childJo = null;
            try {
                childJo = ja.getJSONObject(index);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (childJo == null || (result = SchemaUtils.findFirstKeyJSONObject(childJo, key)) == null) continue;
            return result;
        }
        return null;
    }

    public static Map<String, String> extractMap(JSONObject jo) {
        HashMap resultMap = Maps.newHashMap();
        Iterator keyIterator = jo.keys();
        while (keyIterator.hasNext()) {
            String value;
            String key = (String)keyIterator.next();
            try {
                value = jo.getString(key);
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
            resultMap.put(key, value);
        }
        return resultMap;
    }

    public static JSONObject createJSONObject(Map<String, String> map) {
        JSONObject jo = new JSONObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                jo.put(key, (Object)value);
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
        return jo;
    }

    public static List<String> getStringsFromJSONArray(JSONArray jsonStringArray) throws JSONException {
        ArrayList stringArray = Lists.newArrayListWithCapacity((int)jsonStringArray.length());
        for (int stringIndex = 0; stringIndex < jsonStringArray.length(); ++stringIndex) {
            stringArray.add(jsonStringArray.getString(stringIndex));
        }
        return stringArray;
    }

    public static List<String> getTags(JSONObject jo) throws JSONException {
        if (jo.has(FIELD_TAGS)) {
            return SchemaUtils.getStringsFromJSONArray(jo.getJSONArray(FIELD_TAGS));
        }
        return Collections.emptyList();
    }
}

