/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.schemas.Schema;
import com.datatorrent.lib.appdata.schemas.SchemaUtils;
import com.datatorrent.lib.appdata.schemas.Type;
import com.datatorrent.netlet.util.DTThrowable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SnapshotSchema
implements Schema {
    public static final String SCHEMA_TYPE = "snapshot";
    public static final String SCHEMA_VERSION = "1.0";
    public static final String FIELD_SCHEMA_TYPE = "schemaType";
    public static final String FIELD_SCHEMA_VERSION = "schemaVersion";
    public static final String FIELD_VALUES = "values";
    public static final String FIELD_VALUES_NAME = "name";
    public static final String FIELD_VALUES_TYPE = "type";
    public static final int NUM_KEYS_FIRST_LEVEL = 1;
    public static final int NUM_KEYS_VALUES = 2;
    private String schemaJSON;
    private Map<String, Type> valueToType;
    private FieldsDescriptor valuesDescriptor;
    private Map<String, String> schemaKeys;
    private int schemaID = 0;
    private JSONObject schema;
    private boolean changed = false;

    public SnapshotSchema(String schemaJSON, Map<String, String> schemaKeys) {
        this(schemaJSON);
        this.setSchemaKeys(schemaKeys);
    }

    public SnapshotSchema(int schemaID, String schemaJSON, Map<String, String> schemaKeys) {
        this(schemaJSON, schemaKeys);
        this.schemaID = schemaID;
    }

    public SnapshotSchema(String schemaJSON) {
        this.setSchema(schemaJSON);
        try {
            this.initialize();
        }
        catch (Exception ex) {
            DTThrowable.rethrow((Exception)ex);
        }
    }

    public SnapshotSchema(int schemaID, String schemaJSON) {
        this(schemaJSON);
        this.schemaID = schemaID;
    }

    @Override
    public final void setSchemaKeys(Map<String, String> schemaKeys) {
        this.changed = true;
        if (schemaKeys == null) {
            this.schemaKeys = null;
            return;
        }
        for (Map.Entry<String, String> entry : schemaKeys.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        this.schemaKeys = Collections.unmodifiableMap(Maps.newHashMap(schemaKeys));
    }

    private void initialize() throws JSONException {
        this.schema = new JSONObject(this.schemaJSON);
        if (this.schemaKeys != null) {
            this.schema.put("schemaKeys", (Object)SchemaUtils.createJSONObject(this.schemaKeys));
        }
        this.valueToType = Maps.newHashMap();
        JSONArray values = this.schema.getJSONArray(FIELD_VALUES);
        Preconditions.checkState((values.length() > 0 ? 1 : 0) != 0, (Object)"The schema does not specify any values.");
        for (int index = 0; index < values.length(); ++index) {
            JSONObject value = values.getJSONObject(index);
            String name = value.getString(FIELD_VALUES_NAME);
            String typeName = value.getString(FIELD_VALUES_TYPE);
            Type type = Type.NAME_TO_TYPE.get(typeName);
            this.valueToType.put(name, type);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)(typeName + " is not a valid type."));
        }
        this.valueToType = Collections.unmodifiableMap(this.valueToType);
        this.valuesDescriptor = new FieldsDescriptor(this.valueToType);
        try {
            this.schema.put(FIELD_SCHEMA_TYPE, (Object)SCHEMA_TYPE);
            this.schema.put(FIELD_SCHEMA_VERSION, (Object)SCHEMA_VERSION);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        this.schemaJSON = this.schema.toString();
    }

    public void setTags(Set<String> tags) {
        if (tags == null || tags.isEmpty()) {
            throw new IllegalArgumentException("tags can't be null or empty.");
        }
        try {
            JSONArray tagArray = new JSONArray(tags);
            this.schema.put("tags", (Object)tagArray);
        }
        catch (JSONException e) {
            Preconditions.checkState((boolean)false, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        this.schemaJSON = this.schema.toString();
    }

    protected final void setSchema(String schemaJSON) {
        this.schemaJSON = (String)Preconditions.checkNotNull((Object)schemaJSON);
    }

    @Override
    public String getSchemaJSON() {
        if (!this.changed && this.schemaJSON != null) {
            return this.schemaJSON;
        }
        if (this.schemaKeys == null) {
            this.schema.remove("schemaKeys");
        } else {
            try {
                this.schema.put("schemaKeys", (Object)SchemaUtils.createJSONObject(this.schemaKeys));
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.schemaJSON = this.schema.toString();
        return this.schemaJSON;
    }

    @Override
    public String getSchemaType() {
        return SCHEMA_TYPE;
    }

    @Override
    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public FieldsDescriptor getValuesDescriptor() {
        return this.valuesDescriptor;
    }

    @Override
    public Map<String, String> getSchemaKeys() {
        return this.schemaKeys;
    }

    @Override
    public int getSchemaID() {
        return this.schemaID;
    }
}

