/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public enum TimeBucket {
    ALL("all", null, null),
    SECOND("1s", TimeUnit.SECONDS, "s"),
    MINUTE("1m", TimeUnit.MINUTES, "m"),
    HOUR("1h", TimeUnit.HOURS, "h"),
    DAY("1d", TimeUnit.DAYS, "d");

    public static final String TIME_BUCKET_NAME_REGEX = "1[a-zA-Z]+";
    public static final Pattern TIME_BUCKET_NAME_PATTERN;
    public static final Set<String> SUFFIXES;
    public static final Map<String, TimeBucket> SUFFIX_TO_TIME_BUCKET;
    public static final Map<String, TimeBucket> BUCKET_TO_TYPE;
    public static final Map<TimeUnit, TimeBucket> TIME_UNIT_TO_TIME_BUCKET;
    private final String suffix;
    private String text;
    private TimeUnit timeUnit;

    private TimeBucket(String text, TimeUnit timeUnit, String suffix) {
        this.setText(text);
        this.setTimeUnit(timeUnit);
        this.suffix = suffix;
    }

    private void setText(String text) {
        Preconditions.checkNotNull((Object)text);
        this.text = text;
    }

    private void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getText() {
        return this.text;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long roundDown(long timestamp) {
        if (this.timeUnit == null) {
            return 0L;
        }
        long millis = this.timeUnit.toMillis(1L);
        return timestamp / millis * millis;
    }

    public static TimeBucket getBucket(String name) {
        return BUCKET_TO_TYPE.get(name);
    }

    public static TimeBucket getBucketEx(String name) {
        TimeBucket bucket = TimeBucket.getBucket(name);
        Preconditions.checkArgument((bucket != null ? 1 : 0) != 0, (Object)(name + " is not a valid bucket type."));
        return bucket;
    }

    public static TimeBucket getTimeBucketForSuffixEx(String suffix) {
        Preconditions.checkNotNull((Object)suffix);
        Preconditions.checkArgument((boolean)SUFFIXES.contains(suffix));
        return SUFFIX_TO_TIME_BUCKET.get(suffix);
    }

    static {
        TIME_BUCKET_NAME_PATTERN = Pattern.compile(TIME_BUCKET_NAME_REGEX);
        HashMap bucketToType = Maps.newHashMap();
        HashMap timeUnitToTimeBucket = Maps.newHashMap();
        for (TimeBucket timeBucket : TimeBucket.values()) {
            timeUnitToTimeBucket.put(timeBucket.getTimeUnit(), timeBucket);
            bucketToType.put(timeBucket.getText(), timeBucket);
        }
        BUCKET_TO_TYPE = Collections.unmodifiableMap(bucketToType);
        TIME_UNIT_TO_TIME_BUCKET = Collections.unmodifiableMap(timeUnitToTimeBucket);
        HashSet suffixes = Sets.newHashSet();
        HashMap suffixToTimeBucket = Maps.newHashMap();
        for (TimeBucket timeBucket : TimeBucket.values()) {
            suffixes.add(timeBucket.getSuffix());
            suffixToTimeBucket.put(timeBucket.getSuffix(), timeBucket);
        }
        SUFFIXES = Sets.newHashSet((Iterable)suffixes);
        SUFFIX_TO_TIME_BUCKET = Maps.newHashMap((Map)suffixToTimeBucket);
    }

    public static class TimeBucketComparator
    implements Comparator<TimeBucket> {
        public static final TimeBucketComparator INSTANCE = new TimeBucketComparator();

        private TimeBucketComparator() {
        }

        @Override
        public int compare(TimeBucket timeBucketA, TimeBucket timeBucketB) {
            return timeBucketA.getTimeUnit().compareTo(timeBucketB.getTimeUnit());
        }
    }
}

