/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.schemas;

import com.datatorrent.lib.appdata.schemas.JSONType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum Type implements Serializable
{
    BOOLEAN("boolean", 1, JSONType.BOOLEAN, Boolean.class, Collections.unmodifiableSet(new HashSet<E>())),
    STRING("string", -1, JSONType.STRING, String.class, Collections.unmodifiableSet(new HashSet<E>())),
    CHAR("char", 2, JSONType.STRING, Character.class, (Set<Type>)ImmutableSet.of((Object)STRING)),
    DOUBLE("double", 8, JSONType.NUMBER, Double.class, Collections.unmodifiableSet(new HashSet<E>())),
    FLOAT("float", 4, JSONType.NUMBER, Float.class, (Set<Type>)ImmutableSet.of((Object)DOUBLE)),
    LONG("long", 8, JSONType.NUMBER, Long.class, Collections.unmodifiableSet(new HashSet<E>())),
    INTEGER("integer", 4, JSONType.NUMBER, Integer.class, (Set<Type>)ImmutableSet.of((Object)LONG)),
    SHORT("short", 2, JSONType.NUMBER, Short.class, (Set<Type>)ImmutableSet.of((Object)INTEGER, (Object)LONG)),
    BYTE("byte", 1, JSONType.NUMBER, Byte.class, (Set<Type>)ImmutableSet.of((Object)SHORT, (Object)INTEGER, (Object)LONG)),
    OBJECT("object", -1, JSONType.INVALID, Object.class, Collections.unmodifiableSet(new HashSet<E>()));

    public static final Set<Type> NUMERIC_TYPES;
    public static final Set<Type> NON_NUMERIC_TYPES;
    public static final Map<String, Type> NAME_TO_TYPE;
    public static final Map<Class<?>, Type> CLASS_TO_TYPE;
    private final String name;
    private final JSONType jsonType;
    private final Class<?> clazz;
    private final Set<Type> higherTypes;
    private final int byteSize;

    private Type(String name, int byteSize, JSONType jsonType, Class<?> clazz, Set<Type> higherTypes) {
        this.name = name;
        this.byteSize = byteSize;
        this.jsonType = jsonType;
        this.clazz = clazz;
        this.higherTypes = higherTypes;
    }

    public String getName() {
        return this.name;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public JSONType getJSONType() {
        return this.jsonType;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Set<Type> getHigherTypes() {
        return this.higherTypes;
    }

    public boolean isChildOf(Type type) {
        return this.higherTypes.contains(type);
    }

    public static boolean areRelated(Type a, Type b) {
        return a == b || a.isChildOf(b) || b.isChildOf(a);
    }

    public static Type getType(String name) {
        return NAME_TO_TYPE.get(name);
    }

    public static Type getTypeEx(String name) {
        Type type = Type.getType(name);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)(name + " is not a valid type."));
        return type;
    }

    public static Object promote(Type from, Type to, Object o) {
        if (from == to) {
            return o;
        }
        Preconditions.checkArgument((from != BOOLEAN && from != CHAR && from != LONG && from != DOUBLE ? 1 : 0) != 0, (Object)("Cannot convert " + BOOLEAN.getName() + ", " + CHAR.getName() + ", " + LONG.getName() + ", or " + DOUBLE + " to a larger type."));
        Preconditions.checkArgument((boolean)from.getHigherTypes().contains(to), (Object)(from.getName() + " cannot be promoted to " + to.getName()));
        if (from == FLOAT && to == DOUBLE) {
            return ((Float)o).doubleValue();
        }
        if (from == BYTE) {
            if (to == SHORT) {
                return ((Byte)o).shortValue();
            }
            if (to == INTEGER) {
                return ((Byte)o).intValue();
            }
            if (to == LONG) {
                return ((Byte)o).longValue();
            }
        }
        if (from == SHORT) {
            if (to == INTEGER) {
                return ((Short)o).intValue();
            }
            if (to == LONG) {
                return ((Short)o).longValue();
            }
        }
        if (from == INTEGER && to == LONG) {
            return ((Integer)o).longValue();
        }
        throw new UnsupportedOperationException("This should not happen.");
    }

    static {
        NUMERIC_TYPES = ImmutableSet.of((Object)BYTE, (Object)SHORT, (Object)INTEGER, (Object)LONG, (Object)FLOAT, (Object)DOUBLE, (Object[])new Type[0]);
        NON_NUMERIC_TYPES = ImmutableSet.of((Object)BOOLEAN, (Object)CHAR, (Object)STRING);
        HashMap nameToType = Maps.newHashMap();
        for (Type type : Type.values()) {
            nameToType.put(type.getName(), type);
        }
        NAME_TO_TYPE = Collections.unmodifiableMap(nameToType);
        HashMap clazzToType = Maps.newHashMap();
        for (Type type : Type.values()) {
            clazzToType.put(type.getClazz(), type);
        }
        CLASS_TO_TYPE = Collections.unmodifiableMap(clazzToType);
    }
}

