/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.snapshot;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.InputPortFieldAnnotation;
import com.datatorrent.common.experimental.AppData;
import com.datatorrent.lib.appdata.StoreUtils;
import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.query.AppDataWindowEndQueueManager;
import com.datatorrent.lib.appdata.query.QueryExecutor;
import com.datatorrent.lib.appdata.query.QueryManagerSynchronous;
import com.datatorrent.lib.appdata.query.serde.MessageDeserializerFactory;
import com.datatorrent.lib.appdata.query.serde.MessageSerializerFactory;
import com.datatorrent.lib.appdata.schemas.DataQuerySnapshot;
import com.datatorrent.lib.appdata.schemas.DataResultSnapshot;
import com.datatorrent.lib.appdata.schemas.Message;
import com.datatorrent.lib.appdata.schemas.Query;
import com.datatorrent.lib.appdata.schemas.Result;
import com.datatorrent.lib.appdata.schemas.ResultFormatter;
import com.datatorrent.lib.appdata.schemas.SchemaQuery;
import com.datatorrent.lib.appdata.schemas.SchemaRegistry;
import com.datatorrent.lib.appdata.schemas.SchemaRegistrySingle;
import com.datatorrent.lib.appdata.schemas.SchemaResult;
import com.datatorrent.lib.appdata.schemas.SnapshotSchema;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAppDataSnapshotServer<INPUT_EVENT>
implements Operator,
AppData.Store<String> {
    protected transient QueryManagerSynchronous<Query, Void, MutableLong, Result> queryProcessor;
    private transient MessageDeserializerFactory queryDeserializerFactory;
    protected transient MessageSerializerFactory resultSerializerFactory;
    protected transient SchemaRegistry schemaRegistry;
    protected transient SnapshotSchema schema;
    @NotNull
    protected ResultFormatter resultFormatter = new ResultFormatter();
    protected String snapshotSchemaJSON;
    protected List<GPOMutable> currentData = Lists.newArrayList();
    protected AppData.EmbeddableQueryInfoProvider<String> embeddableQueryInfoProvider;
    protected final transient ConcurrentLinkedQueue<SchemaResult> schemaQueue = new ConcurrentLinkedQueue();
    @AppData.ResultPort
    public final transient DefaultOutputPort<String> queryResult = new DefaultOutputPort();
    protected QueryExecutor<Query, Void, MutableLong, Result> queryExecutor;
    private Set<String> tags;
    @AppData.QueryPort
    @InputPortFieldAnnotation(optional=true)
    public final transient DefaultInputPort<String> query = new DefaultInputPort<String>(){

        public void process(String queryJSON) {
            AbstractAppDataSnapshotServer.this.processQuery(queryJSON);
        }
    };
    public final transient DefaultInputPort<List<INPUT_EVENT>> input = new DefaultInputPort<List<INPUT_EVENT>>(){

        public void process(List<INPUT_EVENT> rows) {
            AbstractAppDataSnapshotServer.this.processData(rows);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAppDataSnapshotServer.class);

    protected void processQuery(String queryJSON) {
        LOG.debug("query {}", (Object)queryJSON);
        Message query = null;
        try {
            query = this.queryDeserializerFactory.deserialize(queryJSON);
        }
        catch (IOException ex) {
            LOG.error("Error parsing query: {}", (Object)queryJSON);
            LOG.error("{}", (Throwable)ex);
            return;
        }
        if (query instanceof SchemaQuery) {
            SchemaResult schemaResult = this.schemaRegistry.getSchemaResult((SchemaQuery)query);
            if (schemaResult != null) {
                LOG.debug("queueing {}", (Object)schemaResult);
                this.schemaQueue.add(schemaResult);
            }
        } else if (query instanceof DataQuerySnapshot) {
            this.queryProcessor.enqueue((DataQuerySnapshot)query, null, null);
        }
    }

    protected void processData(List<INPUT_EVENT> rows) {
        this.currentData.clear();
        for (INPUT_EVENT inputEvent : rows) {
            GPOMutable gpoRow = this.convert(inputEvent);
            this.currentData.add(gpoRow);
        }
    }

    public abstract GPOMutable convert(INPUT_EVENT var1);

    public final void activate(Context.OperatorContext ctx) {
        if (this.embeddableQueryInfoProvider != null) {
            this.embeddableQueryInfoProvider.activate((Context)ctx);
        }
    }

    public void setup(Context.OperatorContext context) {
        this.setupSchema();
        this.schemaRegistry = new SchemaRegistrySingle(this.schema);
        this.setupQueryProcessor();
        this.queryDeserializerFactory = new MessageDeserializerFactory(SchemaQuery.class, DataQuerySnapshot.class);
        this.queryDeserializerFactory.setContext(DataQuerySnapshot.class, this.schemaRegistry);
        this.resultSerializerFactory = new MessageSerializerFactory(this.resultFormatter);
        this.queryProcessor.setup(context);
        if (this.embeddableQueryInfoProvider != null) {
            this.embeddableQueryInfoProvider.enableEmbeddedMode();
            LOG.info("An embeddable query operator is being used of class {}.", (Object)this.embeddableQueryInfoProvider.getClass().getName());
            StoreUtils.attachOutputPortToInputPort(this.embeddableQueryInfoProvider.getOutputPort(), this.query);
            this.embeddableQueryInfoProvider.setup((Context)context);
        }
    }

    protected void setupSchema() {
        this.schema = new SnapshotSchema(this.snapshotSchemaJSON);
        if (this.tags != null && !this.tags.isEmpty()) {
            this.schema.setTags(this.tags);
        }
    }

    protected void setupQueryProcessor() {
        this.queryProcessor = QueryManagerSynchronous.newInstance(this.queryExecutor == null ? new SnapshotComputer() : this.queryExecutor, new AppDataWindowEndQueueManager());
    }

    public void beginWindow(long windowId) {
        if (this.embeddableQueryInfoProvider != null) {
            this.embeddableQueryInfoProvider.beginWindow(windowId);
        }
        this.queryProcessor.beginWindow(windowId);
    }

    public void endWindow() {
        SchemaResult schemaResult;
        Result result;
        if (this.embeddableQueryInfoProvider != null) {
            this.embeddableQueryInfoProvider.endWindow();
        }
        while ((result = this.queryProcessor.process()) != null) {
            String resultJSON = this.resultSerializerFactory.serialize(result);
            LOG.debug("emitting {}", (Object)resultJSON);
            this.queryResult.emit((Object)resultJSON);
        }
        while ((schemaResult = this.schemaQueue.poll()) != null) {
            String schemaResultJSON = this.resultSerializerFactory.serialize(schemaResult);
            LOG.debug("emitting {}", (Object)schemaResultJSON);
            this.queryResult.emit((Object)schemaResultJSON);
        }
        this.queryProcessor.endWindow();
    }

    public void teardown() {
        if (this.embeddableQueryInfoProvider != null) {
            this.embeddableQueryInfoProvider.teardown();
        }
        this.queryProcessor.teardown();
    }

    public void deactivate() {
        if (this.embeddableQueryInfoProvider != null) {
            this.embeddableQueryInfoProvider.deactivate();
        }
    }

    public String getSnapshotSchemaJSON() {
        return this.snapshotSchemaJSON;
    }

    public void setSnapshotSchemaJSON(String snapshotSchemaJSON) {
        this.snapshotSchemaJSON = snapshotSchemaJSON;
    }

    public ResultFormatter getResultFormatter() {
        return this.resultFormatter;
    }

    public void setResultFormatter(ResultFormatter resultFormatter) {
        this.resultFormatter = resultFormatter;
    }

    public AppData.EmbeddableQueryInfoProvider<String> getEmbeddableQueryInfoProvider() {
        return this.embeddableQueryInfoProvider;
    }

    public void setEmbeddableQueryInfoProvider(AppData.EmbeddableQueryInfoProvider<String> embeddableQueryInfoProvider) {
        this.embeddableQueryInfoProvider = (AppData.EmbeddableQueryInfoProvider)Preconditions.checkNotNull(embeddableQueryInfoProvider);
    }

    public QueryExecutor<Query, Void, MutableLong, Result> getQueryExecutor() {
        return this.queryExecutor;
    }

    public void setQueryExecutor(QueryExecutor<Query, Void, MutableLong, Result> queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    public List<GPOMutable> getCurrentData() {
        return this.currentData;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public class SnapshotComputer
    implements QueryExecutor<Query, Void, MutableLong, Result> {
        @Override
        public Result executeQuery(Query query, Void metaQuery, MutableLong queueContext) {
            return new DataResultSnapshot(query, AbstractAppDataSnapshotServer.this.currentData, (long)queueContext.getValue());
        }
    }
}

