/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.appdata.snapshot;

import com.datatorrent.lib.appdata.gpo.GPOMutable;
import com.datatorrent.lib.appdata.schemas.FieldsDescriptor;
import com.datatorrent.lib.appdata.snapshot.AbstractAppDataSnapshotServer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDataSnapshotServerMap
extends AbstractAppDataSnapshotServer<Map<String, Object>> {
    private Map<String, String> tableFieldToMapField;
    private static final Logger LOG = LoggerFactory.getLogger(AppDataSnapshotServerMap.class);

    @Override
    public GPOMutable convert(Map<String, Object> inputEvent) {
        FieldsDescriptor fd = this.schema.getValuesDescriptor();
        GPOMutable values = new GPOMutable(fd);
        List<String> fields = fd.getFieldList();
        for (int index = 0; index < fields.size(); ++index) {
            String field = fields.get(index);
            values.setFieldGeneric(field, inputEvent.get(this.getMapField(field)));
        }
        return values;
    }

    private String getMapField(String field) {
        if (this.tableFieldToMapField == null) {
            return field;
        }
        String mapField = this.tableFieldToMapField.get(field);
        if (mapField == null) {
            return field;
        }
        return mapField;
    }

    public Map<String, String> getTableFieldToMapField() {
        return this.tableFieldToMapField;
    }

    public void setTableFieldToMapField(@NotNull Map<String, String> tableFieldToMapField) {
        Preconditions.checkNotNull(tableFieldToMapField);
        for (Map.Entry<String, String> entry : tableFieldToMapField.entrySet()) {
            Preconditions.checkNotNull((Object)entry.getKey());
            Preconditions.checkNotNull((Object)entry.getValue());
        }
        this.tableFieldToMapField = Maps.newHashMap(tableFieldToMapField);
    }
}

