/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.codec;

import com.datatorrent.api.StreamCodec;
import com.datatorrent.netlet.util.Slice;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class KryoSerializableStreamCodec<T>
implements StreamCodec<T>,
Serializable {
    protected transient Kryo kryo = new Kryo();
    private static final long serialVersionUID = 201411031402L;

    public KryoSerializableStreamCodec() {
        this.kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.kryo = new Kryo();
        this.kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public void register(Class<?> clazz) {
        this.kryo.register(clazz);
    }

    public void register(Class<?> clazz, int id) {
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)"invalid id");
        this.kryo.register(clazz, id);
    }

    public Object fromByteArray(Slice fragment) {
        ByteArrayInputStream is = new ByteArrayInputStream(fragment.buffer, fragment.offset, fragment.length);
        Input input = new Input((InputStream)is);
        return this.kryo.readClassAndObject(input);
    }

    public Slice toByteArray(T info) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)os);
        this.kryo.writeClassAndObject(output, info);
        output.flush();
        return new Slice(os.toByteArray(), 0, os.toByteArray().length);
    }

    public int getPartition(T t) {
        return t.hashCode();
    }
}

