/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.counters;

import com.datatorrent.api.Context;
import com.datatorrent.common.util.NumberAggregate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=Serializer.class)
public class BasicCounters<T extends Number>
implements Serializable {
    private final Map<Enum<?>, T> cache;
    private final Class<T> counterType;
    private static final long serialVersionUID = 201406230033L;

    private BasicCounters() {
        this.cache = null;
        this.counterType = null;
    }

    public BasicCounters(@Nonnull Class<T> counterType) {
        this.cache = Maps.newIdentityHashMap();
        this.counterType = counterType;
    }

    public synchronized T findCounter(Enum<?> counterKey) throws IllegalAccessException, InstantiationException {
        Number counter = (Number)this.cache.get(counterKey);
        if (counter == null) {
            counter = (Number)this.counterType.newInstance();
            this.cache.put(counterKey, counter);
        }
        return (T)counter;
    }

    public synchronized T getCounter(Enum<?> counterKey) {
        return (T)((Number)this.cache.get(counterKey));
    }

    public synchronized void setCounter(Enum<?> counterKey, T value) {
        this.cache.put(counterKey, value);
    }

    public synchronized ImmutableMap<Enum<?>, T> getCopy() {
        return ImmutableMap.copyOf(this.cache);
    }

    public static class DoubleAggregator<T extends Number>
    implements Context.CountersAggregator,
    Serializable {
        private static final long serialVersionUID = 201407011713L;

        public Object aggregate(Collection<?> objects) {
            HashMap aggregates = Maps.newHashMap();
            for (Object counter : objects) {
                if (!(counter instanceof BasicCounters)) continue;
                BasicCounters physical = (BasicCounters)counter;
                ImmutableMap copy = physical.getCopy();
                for (Map.Entry entry : copy.entrySet()) {
                    NumberAggregate.DoubleAggregate aggregate = (NumberAggregate.DoubleAggregate)aggregates.get(((Enum)entry.getKey()).name());
                    if (aggregate == null) {
                        aggregate = new NumberAggregate.DoubleAggregate();
                        aggregates.put(((Enum)entry.getKey()).name(), aggregate);
                    }
                    aggregate.addNumber((Number)((Number)entry.getValue()).doubleValue());
                }
            }
            return ImmutableMap.copyOf((Map)aggregates);
        }
    }

    public static class LongAggregator<T extends Number>
    implements Context.CountersAggregator,
    Serializable {
        private static final long serialVersionUID = 201406222203L;

        public Object aggregate(Collection<?> objects) {
            HashMap aggregates = Maps.newHashMap();
            for (Object counter : objects) {
                if (!(counter instanceof BasicCounters)) continue;
                BasicCounters physical = (BasicCounters)counter;
                ImmutableMap copy = physical.getCopy();
                for (Map.Entry entry : copy.entrySet()) {
                    NumberAggregate.LongAggregate aggregate = (NumberAggregate.LongAggregate)aggregates.get(((Enum)entry.getKey()).name());
                    if (aggregate == null) {
                        aggregate = new NumberAggregate.LongAggregate();
                        aggregates.put(((Enum)entry.getKey()).name(), aggregate);
                    }
                    aggregate.addNumber((Number)((Number)entry.getValue()).longValue());
                }
            }
            return ImmutableMap.copyOf((Map)aggregates);
        }
    }

    public static class Serializer
    extends JsonSerializer<BasicCounters<?>>
    implements Serializable {
        private static final long serialVersionUID = 201406230131L;

        public void serialize(BasicCounters<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value.getCopy());
        }
    }
}

