/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.cache;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.lib.db.Connectable;
import com.datatorrent.lib.db.cache.CacheManager;
import com.datatorrent.lib.util.KeyValPair;
import java.io.IOException;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBLookupCacheBackedOperator<T, S extends Connectable>
implements Operator,
CacheManager.Backup {
    @NotNull
    protected S store;
    @NotNull
    protected CacheManager cacheManager;
    public final transient DefaultInputPort<T> input = new DefaultInputPort<T>(){

        public void process(T tuple) {
            AbstractDBLookupCacheBackedOperator.this.processTuple(tuple);
        }
    };
    public final transient DefaultOutputPort<KeyValPair<Object, Object>> output = new DefaultOutputPort();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDBLookupCacheBackedOperator.class);

    protected AbstractDBLookupCacheBackedOperator() {
        this.cacheManager = new CacheManager();
    }

    protected void processTuple(T tuple) {
        Object key = this.getKeyFromTuple(tuple);
        Object value = this.cacheManager.get(key);
        if (value != null) {
            this.output.emit(new KeyValPair<Object, Object>(key, value));
        }
    }

    public void beginWindow(long l) {
    }

    public void endWindow() {
    }

    public void setup(Context.OperatorContext context) {
        this.cacheManager.setBackup(this);
        try {
            this.cacheManager.initialize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void teardown() {
        try {
            this.cacheManager.close();
        }
        catch (IOException e) {
            LOG.error("closing manager", (Throwable)e);
        }
    }

    @Override
    public void connect() throws IOException {
        this.store.connect();
    }

    @Override
    public boolean isConnected() {
        return this.store.isConnected();
    }

    @Override
    public void disconnect() throws IOException {
        this.store.disconnect();
    }

    public void setStore(S store) {
        this.store = store;
    }

    public S getStore() {
        return this.store;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected abstract Object getKeyFromTuple(T var1);
}

