/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.cache;

import com.datatorrent.lib.db.KeyValueStore;
import com.datatorrent.lib.db.cache.CacheStore;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManager
implements Closeable {
    @NotNull
    protected Primary primary = new CacheStore();
    @NotNull
    protected Backup backup;
    protected String refreshTime;
    private transient Timer refresher;
    private static final Logger LOG = LoggerFactory.getLogger(CacheManager.class);

    public void initialize() throws IOException {
        this.primary.connect();
        this.backup.connect();
        Map<Object, Object> initialEntries = this.backup.loadInitialData();
        if (initialEntries != null) {
            this.primary.putAll(initialEntries);
        }
        if (!Strings.isNullOrEmpty((String)this.refreshTime)) {
            String[] parts = this.refreshTime.split("[:\\s]");
            Calendar timeToRefresh = Calendar.getInstance();
            timeToRefresh.set(11, Integer.parseInt(parts[0]));
            if (parts.length >= 2) {
                timeToRefresh.set(12, Integer.parseInt(parts[1]));
            }
            if (parts.length >= 3) {
                timeToRefresh.set(13, Integer.parseInt(parts[2]));
            }
            long initialDelay = timeToRefresh.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    List<Object> refreshedValues;
                    ArrayList keysToRefresh = Lists.newArrayList(CacheManager.this.primary.getKeys());
                    if (keysToRefresh.size() > 0 && (refreshedValues = CacheManager.this.backup.getAll(keysToRefresh)) != null) {
                        for (int i = 0; i < keysToRefresh.size(); ++i) {
                            CacheManager.this.primary.put(keysToRefresh.get(i), refreshedValues.get(i));
                        }
                    }
                }
            };
            this.refresher = new Timer();
            if (initialDelay < 0L) {
                this.refresher.schedule(task, 0L);
                timeToRefresh.add(5, 1);
                initialDelay = timeToRefresh.getTimeInMillis();
            }
            this.refresher.scheduleAtFixedRate(task, initialDelay, 86400000L);
        }
    }

    @Nullable
    public Object get(@Nonnull Object key) {
        Object primaryVal = this.primary.get(key);
        if (primaryVal != null) {
            return primaryVal;
        }
        Object backupVal = this.backup.get(key);
        if (backupVal != null) {
            this.primary.put(key, backupVal);
        }
        return backupVal;
    }

    public void put(@Nonnull Object key, @Nonnull Object value) {
        this.primary.put(key, value);
        this.backup.put(key, value);
    }

    @Override
    public void close() throws IOException {
        this.refresher.cancel();
        this.primary.disconnect();
        this.backup.disconnect();
    }

    public void setPrimary(Primary primary) {
        this.primary = primary;
    }

    public Primary getPrimary() {
        return this.primary;
    }

    public void setBackup(Backup backup) {
        this.backup = backup;
    }

    public Backup getBackup() {
        return this.backup;
    }

    public void setRefreshTime(String time) {
        this.refreshTime = time;
    }

    public String getRefreshTime() {
        return this.refreshTime;
    }

    public static interface Backup
    extends KeyValueStore {
        public Map<Object, Object> loadInitialData();
    }

    public static interface Primary
    extends KeyValueStore {
        public Set<Object> getKeys();
    }
}

