/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.cache;

import com.datatorrent.lib.db.cache.CacheManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class CacheStore
implements CacheManager.Primary {
    @Min(value=0L)
    protected long maxCacheSize = 2000L;
    @Min(value=0L)
    protected int entryExpiryDurationInMillis = 60000;
    @Min(value=0L)
    protected int cacheCleanupIntervalInMillis = 60500;
    @NotNull
    protected ExpiryType entryExpiryStrategy = ExpiryType.EXPIRE_AFTER_ACCESS;
    private transient ScheduledExecutorService cleanupScheduler;
    private transient Cache<Object, Object> cache;
    private transient boolean open;

    @Override
    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public Set<Object> getKeys() {
        return this.cache.asMap().keySet();
    }

    @Override
    public void putAll(Map<Object, Object> data) {
        this.cache.asMap().putAll(data);
    }

    @Override
    public void remove(Object key) {
        this.cache.invalidate(key);
    }

    @Override
    public Object get(Object key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public List<Object> getAll(List<Object> keys) {
        ArrayList values = Lists.newArrayList();
        for (Object key : keys) {
            values.add(this.cache.getIfPresent(key));
        }
        return values;
    }

    @Override
    public void connect() throws IOException {
        this.open = true;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.entryExpiryStrategy == ExpiryType.EXPIRE_AFTER_ACCESS) {
            cacheBuilder.expireAfterAccess((long)this.entryExpiryDurationInMillis, TimeUnit.MILLISECONDS);
        } else if (this.entryExpiryStrategy == ExpiryType.EXPIRE_AFTER_WRITE) {
            cacheBuilder.expireAfterWrite((long)this.entryExpiryDurationInMillis, TimeUnit.MILLISECONDS);
        }
        this.cache = cacheBuilder.build();
        this.cleanupScheduler = Executors.newScheduledThreadPool(1);
        this.cleanupScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CacheStore.this.cache.cleanUp();
            }
        }, this.cacheCleanupIntervalInMillis, this.cacheCleanupIntervalInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isConnected() {
        return this.open;
    }

    @Override
    public void disconnect() throws IOException {
        this.open = false;
        this.cleanupScheduler.shutdown();
    }

    public void setMaxCacheSize(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setEntryExpiryStrategy(ExpiryType expiryType) {
        this.entryExpiryStrategy = expiryType;
    }

    public void setEntryExpiryDurationInMillis(int durationInMillis) {
        this.entryExpiryDurationInMillis = durationInMillis;
    }

    public void setCacheCleanupInMillis(int durationInMillis) {
        this.cacheCleanupIntervalInMillis = durationInMillis;
    }

    public static enum ExpiryType {
        EXPIRE_AFTER_ACCESS,
        EXPIRE_AFTER_WRITE;

    }
}

