/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.jdbc;

import com.datatorrent.api.Context;
import com.datatorrent.lib.db.AbstractStoreInputOperator;
import com.datatorrent.lib.db.jdbc.JdbcStore;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public abstract class AbstractJdbcInputOperator<T>
extends AbstractStoreInputOperator<T, JdbcStore> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJdbcInputOperator.class);
    protected transient Statement queryStatement;

    public abstract T getTuple(ResultSet var1);

    public abstract String queryToRetrieveData();

    public void emitTuples() {
        String query = this.queryToRetrieveData();
        logger.debug(String.format("select statement: %s", query));
        try {
            ResultSet result = this.queryStatement.executeQuery(query);
            if (result.next()) {
                do {
                    T tuple = this.getTuple(result);
                    this.outputPort.emit(tuple);
                } while (result.next());
            }
        }
        catch (SQLException ex) {
            ((JdbcStore)this.store).disconnect();
            throw new RuntimeException(String.format("Error while running query: %s", query), ex);
        }
    }

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        try {
            this.queryStatement = ((JdbcStore)this.store).getConnection().createStatement();
        }
        catch (SQLException e) {
            throw new RuntimeException("creating query", e);
        }
    }
}

