/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.jdbc;

import com.datatorrent.api.Context;
import com.datatorrent.lib.db.AbstractStoreOutputOperator;
import com.datatorrent.lib.db.jdbc.JdbcStore;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public abstract class AbstractJdbcNonTransactionableOutputOperator<T, S extends JdbcStore>
extends AbstractStoreOutputOperator<T, S> {
    protected transient PreparedStatement updateCommand;

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        try {
            this.updateCommand = ((JdbcStore)this.store).getConnection().prepareStatement(this.getUpdateCommand());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void processTuple(T tuple) {
        try {
            this.setStatementParameters(this.updateCommand, tuple);
            this.updateCommand.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String getUpdateCommand();

    protected abstract void setStatementParameters(PreparedStatement var1, T var2) throws SQLException;
}

