/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.jdbc;

import com.datatorrent.api.Context;
import com.datatorrent.lib.db.AbstractPassThruTransactionableStoreOutputOperator;
import com.datatorrent.lib.db.jdbc.JdbcTransactionalStore;
import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcTransactionableOutputOperator<T>
extends AbstractPassThruTransactionableStoreOutputOperator<T, JdbcTransactionalStore> {
    protected static int DEFAULT_BATCH_SIZE = 1000;
    @Min(value=1L)
    private int batchSize;
    private final List<T> tuples = Lists.newArrayList();
    private transient int batchStartIdx = 0;
    private transient PreparedStatement updateCommand;
    private static final Logger logger = LoggerFactory.getLogger(AbstractJdbcTransactionableOutputOperator.class);

    public AbstractJdbcTransactionableOutputOperator() {
        this.batchSize = DEFAULT_BATCH_SIZE;
        this.store = new JdbcTransactionalStore();
    }

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        try {
            this.updateCommand = ((JdbcTransactionalStore)this.store).connection.prepareStatement(this.getUpdateCommand());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endWindow() {
        if (this.tuples.size() - this.batchStartIdx > 0) {
            this.processBatch();
        }
        super.endWindow();
        this.tuples.clear();
        this.batchStartIdx = 0;
    }

    @Override
    public void processTuple(T tuple) {
        this.tuples.add(tuple);
        if (this.tuples.size() - this.batchStartIdx >= this.batchSize) {
            this.processBatch();
        }
    }

    private void processBatch() {
        logger.debug("start {} end {}", (Object)this.batchStartIdx, (Object)this.tuples.size());
        try {
            for (int i = this.batchStartIdx; i < this.tuples.size(); ++i) {
                this.setStatementParameters(this.updateCommand, this.tuples.get(i));
                this.updateCommand.addBatch();
            }
            this.updateCommand.executeBatch();
            this.updateCommand.clearBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("processing batch", e);
        }
        finally {
            this.batchStartIdx += this.tuples.size() - this.batchStartIdx;
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @NotNull
    protected abstract String getUpdateCommand();

    protected abstract void setStatementParameters(PreparedStatement var1, T var2) throws SQLException;
}

