/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.jdbc;

import com.datatorrent.api.Context;
import com.datatorrent.lib.db.cache.AbstractDBLookupCacheBackedOperator;
import com.datatorrent.lib.db.jdbc.JdbcStore;
import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public abstract class JDBCLookupCacheBackedOperator<T>
extends AbstractDBLookupCacheBackedOperator<T, JdbcStore> {
    @NotNull
    protected String tableName;
    protected transient PreparedStatement putStatement;
    protected transient PreparedStatement getStatement;

    public JDBCLookupCacheBackedOperator() {
        this.store = new JdbcStore();
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        String insertQuery = this.fetchInsertQuery();
        String getQuery = this.fetchGetQuery();
        try {
            this.putStatement = ((JdbcStore)this.store).connection.prepareStatement(insertQuery);
            this.getStatement = ((JdbcStore)this.store).connection.prepareStatement(getQuery);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void put(@Nonnull Object key, @Nonnull Object value) {
        try {
            this.preparePutStatement(this.putStatement, key, value);
            this.putStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("while executing insert", e);
        }
    }

    @Override
    public Object get(Object key) {
        try {
            this.prepareGetStatement(this.getStatement, key);
            ResultSet resultSet = this.getStatement.executeQuery();
            return this.processResultSet(resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException("while fetching key", e);
        }
    }

    @Override
    public List<Object> getAll(List<Object> keys) {
        ArrayList values = Lists.newArrayList();
        for (Object key : keys) {
            try {
                this.prepareGetStatement(this.getStatement, key);
                ResultSet resultSet = this.getStatement.executeQuery();
                values.add(this.processResultSet(resultSet));
            }
            catch (SQLException e) {
                throw new RuntimeException("while fetching keys", e);
            }
        }
        return values;
    }

    protected abstract void prepareGetStatement(PreparedStatement var1, Object var2) throws SQLException;

    protected abstract void preparePutStatement(PreparedStatement var1, Object var2, Object var3) throws SQLException;

    protected abstract String fetchInsertQuery();

    protected abstract String fetchGetQuery();

    protected abstract Object processResultSet(ResultSet var1) throws SQLException;
}

