/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.jdbc;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.OutputPortFieldAnnotation;
import com.datatorrent.lib.db.jdbc.AbstractJdbcInputOperator;
import com.datatorrent.lib.db.jdbc.JdbcStore;
import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.PojoUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class JdbcPOJOInputOperator
extends AbstractJdbcInputOperator<Object>
implements Operator.ActivationListener<Context.OperatorContext> {
    private static int DEF_FETCH_SIZE = 100;
    private String tableName;
    private String whereCondition;
    private String groupByClause;
    private String havingCondition;
    private String orderByExpr;
    private String query;
    private boolean mysqlSyntax = true;
    @NotNull
    private List<FieldInfo> fieldInfos;
    @Min(value=1L)
    private int fetchSize;
    private int fetchDirection;
    private final transient List<ActiveFieldInfo> columnFieldSetters;
    private transient boolean windowDone;
    protected String columnsExpression;
    protected List<Integer> columnDataTypes;
    private transient PreparedStatement preparedStatement;
    protected transient Class<?> pojoClass;
    protected int pageNumber;
    @AutoMetric
    protected long tuplesRead;
    @OutputPortFieldAnnotation(schemaRequired=true)
    public final transient DefaultOutputPort<Object> outputPort = new DefaultOutputPort<Object>(){

        public void setup(Context.PortContext context) {
            JdbcPOJOInputOperator.this.pojoClass = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }
    };
    public static final Logger LOG = LoggerFactory.getLogger(JdbcPOJOInputOperator.class);

    public JdbcPOJOInputOperator() {
        this.fetchSize = DEF_FETCH_SIZE;
        this.columnFieldSetters = Lists.newArrayList();
    }

    @Override
    public void setup(Context.OperatorContext context) {
        Preconditions.checkArgument((this.query != null || this.tableName != null ? 1 : 0) != 0, (Object)"both query and table name are not set");
        super.setup(context);
        try {
            this.queryStatement.close();
            if (this.query == null && this.columnsExpression == null) {
                StringBuilder columns = new StringBuilder();
                for (int i = 0; i < this.fieldInfos.size(); ++i) {
                    columns.append(this.fieldInfos.get(i).getColumnName());
                    if (i >= this.fieldInfos.size() - 1) continue;
                    columns.append(",");
                }
                this.columnsExpression = columns.toString();
                LOG.debug("select expr {}", (Object)this.columnsExpression);
            }
            this.preparedStatement = ((JdbcStore)this.store).connection.prepareStatement(this.queryToRetrieveData());
            if (this.columnDataTypes == null) {
                this.populateColumnDataTypes();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        for (FieldInfo fi : this.fieldInfos) {
            this.columnFieldSetters.add(new ActiveFieldInfo(fi));
        }
    }

    protected void populateColumnDataTypes() throws SQLException {
        this.columnDataTypes = Lists.newArrayList();
        this.preparedStatement.setMaxRows(0);
        this.setRuntimeParams();
        try (ResultSet rs = this.preparedStatement.executeQuery();){
            HashMap nameToType = Maps.newHashMap();
            ResultSetMetaData rsMetaData = rs.getMetaData();
            LOG.debug("resultSet MetaData column count {}", (Object)rsMetaData.getColumnCount());
            for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                int type = rsMetaData.getColumnType(i);
                String name = rsMetaData.getColumnName(i);
                LOG.debug("column name {} type {}", (Object)name, (Object)type);
                if (this.query == null) {
                    this.columnDataTypes.add(type);
                    continue;
                }
                nameToType.put(name, type);
            }
            if (this.query != null) {
                for (FieldInfo fieldInfo : this.fieldInfos) {
                    this.columnDataTypes.add((Integer)nameToType.get(fieldInfo.getColumnName()));
                }
            }
        }
        this.preparedStatement.setFetchSize(this.fetchSize);
        this.preparedStatement.setMaxRows(this.fetchSize);
    }

    @Override
    public void beginWindow(long l) {
        this.windowDone = false;
        this.tuplesRead = 0L;
    }

    @Override
    public void emitTuples() {
        if (!this.windowDone) {
            try {
                this.setRuntimeParams();
                ResultSet resultSet = this.preparedStatement.executeQuery();
                if (resultSet.next()) {
                    do {
                        Object tuple = this.getTuple(resultSet);
                        this.outputPort.emit(tuple);
                        ++this.tuplesRead;
                    } while (resultSet.next());
                } else {
                    this.windowDone = true;
                }
                resultSet.close();
                ++this.pageNumber;
            }
            catch (SQLException ex) {
                ((JdbcStore)this.store).disconnect();
                throw new RuntimeException(ex);
            }
        }
    }

    protected void setRuntimeParams() throws SQLException {
        if (this.mysqlSyntax) {
            this.preparedStatement.setLong(1, this.pageNumber * this.fetchSize);
        } else {
            this.preparedStatement.setLong(1, this.pageNumber * this.fetchSize);
        }
    }

    @Override
    public Object getTuple(ResultSet result) {
        Object obj;
        try {
            obj = this.pojoClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            ((JdbcStore)this.store).disconnect();
            throw new RuntimeException(ex);
        }
        try {
            block18: for (int i = 0; i < this.fieldInfos.size(); ++i) {
                int type = this.columnDataTypes.get(i);
                ActiveFieldInfo afi = this.columnFieldSetters.get(i);
                switch (type) {
                    case 1: 
                    case 12: {
                        String strVal = result.getString(i + 1);
                        ((PojoUtils.Setter)afi.setterOrGetter).set(obj, strVal);
                        continue block18;
                    }
                    case 16: {
                        boolean boolVal = result.getBoolean(i + 1);
                        ((PojoUtils.SetterBoolean)afi.setterOrGetter).set(obj, boolVal);
                        continue block18;
                    }
                    case -6: {
                        byte byteVal = result.getByte(i + 1);
                        ((PojoUtils.SetterByte)afi.setterOrGetter).set(obj, byteVal);
                        continue block18;
                    }
                    case 5: {
                        short shortVal = result.getShort(i + 1);
                        ((PojoUtils.SetterShort)afi.setterOrGetter).set(obj, shortVal);
                        continue block18;
                    }
                    case 4: {
                        int intVal = result.getInt(i + 1);
                        ((PojoUtils.SetterInt)afi.setterOrGetter).set(obj, intVal);
                        continue block18;
                    }
                    case -5: {
                        long longVal = result.getLong(i + 1);
                        ((PojoUtils.SetterLong)afi.setterOrGetter).set(obj, longVal);
                        continue block18;
                    }
                    case 6: {
                        float floatVal = result.getFloat(i + 1);
                        ((PojoUtils.SetterFloat)afi.setterOrGetter).set(obj, floatVal);
                        continue block18;
                    }
                    case 8: {
                        double doubleVal = result.getDouble(i + 1);
                        ((PojoUtils.SetterDouble)afi.setterOrGetter).set(obj, doubleVal);
                        continue block18;
                    }
                    case 3: {
                        BigDecimal bdVal = result.getBigDecimal(i + 1);
                        ((PojoUtils.Setter)afi.setterOrGetter).set(obj, bdVal);
                        continue block18;
                    }
                    case 93: {
                        Timestamp tsVal = result.getTimestamp(i + 1);
                        ((PojoUtils.SetterLong)afi.setterOrGetter).set(obj, tsVal.getTime());
                        continue block18;
                    }
                    case 92: {
                        Time timeVal = result.getTime(i + 1);
                        ((PojoUtils.SetterLong)afi.setterOrGetter).set(obj, timeVal.getTime());
                        continue block18;
                    }
                    case 91: {
                        Date dateVal = result.getDate(i + 1);
                        ((PojoUtils.SetterLong)afi.setterOrGetter).set(obj, dateVal.getTime());
                        continue block18;
                    }
                    default: {
                        this.handleUnknownDataType(type, obj, afi);
                    }
                }
            }
            return obj;
        }
        catch (SQLException e) {
            ((JdbcStore)this.store).disconnect();
            throw new RuntimeException("fetching metadata", e);
        }
    }

    protected void handleUnknownDataType(int type, Object tuple, ActiveFieldInfo activeFieldInfo) {
        throw new RuntimeException("unsupported data type " + type);
    }

    @Override
    public String queryToRetrieveData() {
        StringBuilder builder = new StringBuilder();
        if (this.query != null) {
            builder.append(this.query.trim());
            if (builder.charAt(builder.length() - 1) == ';') {
                builder.deleteCharAt(builder.length() - 1);
            }
        } else {
            builder.append("SELECT ").append(this.columnsExpression).append(" FROM ").append(this.tableName);
            if (this.whereCondition != null) {
                builder.append(" WHERE ").append(this.whereCondition);
            }
            if (this.groupByClause != null) {
                builder.append(" GROUP BY ").append(this.groupByClause);
                if (this.havingCondition != null) {
                    builder.append(" HAVING ").append(this.havingCondition);
                }
            }
            if (this.orderByExpr != null) {
                builder.append(" ORDER BY ").append(this.orderByExpr);
            }
        }
        if (this.mysqlSyntax) {
            builder.append(" LIMIT ").append(this.fetchSize).append(" OFFSET ?");
        } else {
            builder.append(" OFFSET ? ROWS FETCH NEXT ").append(this.fetchSize).append(" ROWS ONLY");
        }
        builder.append(";");
        String queryStr = builder.toString();
        LOG.debug("built query {}", (Object)queryStr);
        return queryStr;
    }

    public void activate(Context.OperatorContext context) {
        block14: for (int i = 0; i < this.columnDataTypes.size(); ++i) {
            int type = this.columnDataTypes.get(i);
            ActiveFieldInfo activeFieldInfo = this.columnFieldSetters.get(i);
            switch (type) {
                case 1: 
                case 12: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetter(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression(), String.class);
                    continue block14;
                }
                case 16: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterBoolean(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case -6: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterByte(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 5: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterShort(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 4: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterInt(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case -5: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterLong(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 6: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterFloat(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 8: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterDouble(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 3: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetter(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression(), BigDecimal.class);
                    continue block14;
                }
                case 93: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterLong(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 92: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterLong(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 91: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createSetterLong(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                default: {
                    this.handleUnknownDataType(type, null, activeFieldInfo);
                }
            }
        }
    }

    public void deactivate() {
    }

    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public void setFieldInfos(List<FieldInfo> fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(String whereCondition) {
        this.whereCondition = whereCondition;
    }

    public String getGroupByClause() {
        return this.groupByClause;
    }

    public void setGroupByClause(String groupByClause) {
        this.groupByClause = groupByClause;
    }

    public String getHavingCondition() {
        return this.havingCondition;
    }

    public void setHavingCondition(String havingCondition) {
        this.havingCondition = havingCondition;
    }

    public String getOrderByExpr() {
        return this.orderByExpr;
    }

    public void setOrderByExpr(String orderByExpr) {
        this.orderByExpr = orderByExpr;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public void setFetchDirection(int fetchDirection) {
        this.fetchDirection = fetchDirection;
    }

    public boolean isMysqlSyntax() {
        return this.mysqlSyntax;
    }

    public void setMysqlSyntax(boolean mysqlSyntax) {
        this.mysqlSyntax = mysqlSyntax;
    }

    protected static class ActiveFieldInfo {
        final FieldInfo fieldInfo;
        Object setterOrGetter;

        ActiveFieldInfo(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
        }
    }
}

