/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.jdbc;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.InputPortFieldAnnotation;
import com.datatorrent.lib.db.AbstractTransactionableStoreOutputOperator;
import com.datatorrent.lib.db.jdbc.AbstractJdbcTransactionableOutputOperator;
import com.datatorrent.lib.db.jdbc.JdbcPOJOInputOperator;
import com.datatorrent.lib.db.jdbc.JdbcTransactionalStore;
import com.datatorrent.lib.util.FieldInfo;
import com.datatorrent.lib.util.PojoUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class JdbcPOJOOutputOperator
extends AbstractJdbcTransactionableOutputOperator<Object>
implements Operator.ActivationListener<Context.OperatorContext> {
    @NotNull
    private List<FieldInfo> fieldInfos;
    private List<Integer> columnDataTypes;
    @NotNull
    private String tablename;
    private final transient List<JdbcPOJOInputOperator.ActiveFieldInfo> columnFieldGetters;
    private String insertStatement;
    private transient Class<?> pojoClass;
    @InputPortFieldAnnotation(optional=true, schemaRequired=true)
    public final transient DefaultInputPort<Object> input = new DefaultInputPort<Object>(){

        public void setup(Context.PortContext context) {
            JdbcPOJOOutputOperator.this.pojoClass = (Class)context.getValue(Context.PortContext.TUPLE_CLASS);
        }

        public void process(Object t) {
            ((AbstractTransactionableStoreOutputOperator)JdbcPOJOOutputOperator.this).input.process(t);
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(JdbcPOJOOutputOperator.class);

    @Override
    public void setup(Context.OperatorContext context) {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            columns.append(this.fieldInfos.get(i).getColumnName());
            values.append("?");
            if (i >= this.fieldInfos.size() - 1) continue;
            columns.append(",");
            values.append(",");
        }
        this.insertStatement = "INSERT INTO " + this.tablename + " (" + columns.toString() + ")" + " VALUES (" + values.toString() + ")";
        LOG.debug("insert statement is {}", (Object)this.insertStatement);
        super.setup(context);
        if (this.columnDataTypes == null) {
            try {
                this.populateColumnDataTypes(columns.toString());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        for (FieldInfo fi : this.fieldInfos) {
            this.columnFieldGetters.add(new JdbcPOJOInputOperator.ActiveFieldInfo(fi));
        }
    }

    protected void populateColumnDataTypes(String columns) throws SQLException {
        this.columnDataTypes = Lists.newArrayList();
        try (Statement st = ((JdbcTransactionalStore)this.store).getConnection().createStatement();){
            ResultSet rs = st.executeQuery("select " + columns + " from " + this.tablename);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            LOG.debug("resultSet MetaData column count {}", (Object)rsMetaData.getColumnCount());
            for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                int type = rsMetaData.getColumnType(i);
                this.columnDataTypes.add(type);
                LOG.debug("column name {} type {}", (Object)rsMetaData.getColumnName(i), (Object)type);
            }
        }
    }

    public JdbcPOJOOutputOperator() {
        this.columnFieldGetters = Lists.newArrayList();
    }

    @Override
    protected String getUpdateCommand() {
        LOG.debug("insert statement is {}", (Object)this.insertStatement);
        return this.insertStatement;
    }

    @Override
    protected void setStatementParameters(PreparedStatement statement, Object tuple) throws SQLException {
        int size = this.columnDataTypes.size();
        block14: for (int i = 0; i < size; ++i) {
            int type = this.columnDataTypes.get(i);
            JdbcPOJOInputOperator.ActiveFieldInfo activeFieldInfo = this.columnFieldGetters.get(i);
            switch (type) {
                case 1: 
                case 12: {
                    statement.setString(i + 1, (String)((PojoUtils.Getter)activeFieldInfo.setterOrGetter).get(tuple));
                    continue block14;
                }
                case 16: {
                    statement.setBoolean(i + 1, ((PojoUtils.GetterBoolean)activeFieldInfo.setterOrGetter).get(tuple));
                    continue block14;
                }
                case -6: {
                    statement.setByte(i + 1, ((PojoUtils.GetterByte)activeFieldInfo.setterOrGetter).get(tuple));
                    continue block14;
                }
                case 5: {
                    statement.setShort(i + 1, ((PojoUtils.GetterShort)activeFieldInfo.setterOrGetter).get(tuple));
                    continue block14;
                }
                case 4: {
                    statement.setInt(i + 1, ((PojoUtils.GetterInt)activeFieldInfo.setterOrGetter).get(tuple));
                    continue block14;
                }
                case -5: {
                    statement.setLong(i + 1, ((PojoUtils.GetterLong)activeFieldInfo.setterOrGetter).get(tuple));
                    continue block14;
                }
                case 6: {
                    statement.setFloat(i + 1, ((PojoUtils.GetterFloat)activeFieldInfo.setterOrGetter).get(tuple));
                    continue block14;
                }
                case 8: {
                    statement.setDouble(i + 1, ((PojoUtils.GetterDouble)activeFieldInfo.setterOrGetter).get(tuple));
                    continue block14;
                }
                case 3: {
                    statement.setBigDecimal(i + 1, (BigDecimal)((PojoUtils.Getter)activeFieldInfo.setterOrGetter).get(tuple));
                    continue block14;
                }
                case 93: {
                    statement.setTimestamp(i + 1, new Timestamp(((PojoUtils.GetterLong)activeFieldInfo.setterOrGetter).get(tuple)));
                    continue block14;
                }
                case 92: {
                    statement.setTime(i + 1, new Time(((PojoUtils.GetterLong)activeFieldInfo.setterOrGetter).get(tuple)));
                    continue block14;
                }
                case 91: {
                    statement.setDate(i + 1, new Date(((PojoUtils.GetterLong)activeFieldInfo.setterOrGetter).get(tuple)));
                    continue block14;
                }
                default: {
                    this.handleUnknownDataType(type, tuple, activeFieldInfo);
                }
            }
        }
    }

    protected void handleUnknownDataType(int type, Object tuple, JdbcPOJOInputOperator.ActiveFieldInfo activeFieldInfo) {
        throw new RuntimeException("unsupported data type " + type);
    }

    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public void setFieldInfos(List<FieldInfo> fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void activate(Context.OperatorContext context) {
        int size = this.columnDataTypes.size();
        block14: for (int i = 0; i < size; ++i) {
            int type = this.columnDataTypes.get(i);
            JdbcPOJOInputOperator.ActiveFieldInfo activeFieldInfo = this.columnFieldGetters.get(i);
            switch (type) {
                case 1: 
                case 12: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetter(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression(), String.class);
                    continue block14;
                }
                case 16: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterBoolean(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case -6: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterByte(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 5: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterShort(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 4: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterInt(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case -5: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterLong(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 6: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterFloat(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 8: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterDouble(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 3: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetter(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression(), BigDecimal.class);
                    continue block14;
                }
                case 93: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterLong(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 92: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterLong(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                case 91: {
                    activeFieldInfo.setterOrGetter = PojoUtils.createGetterLong(this.pojoClass, activeFieldInfo.fieldInfo.getPojoFieldExpression());
                    continue block14;
                }
                default: {
                    this.handleUnknownDataType(type, null, activeFieldInfo);
                }
            }
        }
    }

    public void deactivate() {
    }
}

