/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.jdbc;

import com.datatorrent.lib.db.Connectable;
import com.datatorrent.netlet.util.DTThrowable;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStore
implements Connectable {
    protected static final Logger logger = LoggerFactory.getLogger(JdbcStore.class);
    @NotNull
    private String databaseUrl;
    @NotNull
    private String databaseDriver;
    private Properties connectionProperties = new Properties();
    protected transient Connection connection = null;

    @NotNull
    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(@NotNull String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    @NotNull
    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(@NotNull String databaseDriver) {
        this.databaseDriver = databaseDriver;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setUserName(String userName) {
        this.connectionProperties.put("user", userName);
    }

    public void setPassword(String password) {
        this.connectionProperties.put("password", password);
    }

    public void setConnectionProperties(String connectionProps) {
        String[] properties = (String[])Iterables.toArray((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)":,")).omitEmptyStrings().trimResults().split((CharSequence)connectionProps), String.class);
        for (int i = 0; i < properties.length; i += 2) {
            if (i + 1 >= properties.length) continue;
            this.connectionProperties.put(properties[i], properties[i + 1]);
        }
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public void connect() {
        try {
            Class.forName(this.databaseDriver).newInstance();
            this.connection = DriverManager.getConnection(this.databaseUrl, this.connectionProperties);
            logger.debug("JDBC connection Success");
        }
        catch (Throwable t) {
            DTThrowable.rethrow((Throwable)t);
        }
    }

    @Override
    public void disconnect() {
        try {
            this.connection.close();
        }
        catch (SQLException ex) {
            throw new RuntimeException("closing database resource", ex);
        }
    }

    @Override
    @JsonIgnore
    public boolean isConnected() {
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new RuntimeException("is isConnected", e);
        }
    }
}

