/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.db.jdbc;

import com.datatorrent.lib.db.TransactionableStore;
import com.datatorrent.lib.db.jdbc.JdbcStore;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTransactionalStore
extends JdbcStore
implements TransactionableStore {
    private static final transient Logger LOG = LoggerFactory.getLogger(JdbcTransactionalStore.class);
    public static String DEFAULT_APP_ID_COL = "dt_app_id";
    public static String DEFAULT_OPERATOR_ID_COL = "dt_operator_id";
    public static String DEFAULT_WINDOW_COL = "dt_window";
    public static String DEFAULT_META_TABLE = "dt_meta";
    @NotNull
    protected String metaTableAppIdColumn;
    @NotNull
    protected String metaTableOperatorIdColumn;
    @NotNull
    protected String metaTableWindowColumn;
    @NotNull
    private String metaTable = DEFAULT_META_TABLE;
    private boolean inTransaction = false;
    protected transient PreparedStatement lastWindowFetchCommand;
    protected transient PreparedStatement lastWindowInsertCommand;
    protected transient PreparedStatement lastWindowUpdateCommand;
    protected transient PreparedStatement lastWindowDeleteCommand;

    public JdbcTransactionalStore() {
        this.metaTableAppIdColumn = DEFAULT_APP_ID_COL;
        this.metaTableOperatorIdColumn = DEFAULT_OPERATOR_ID_COL;
        this.metaTableWindowColumn = DEFAULT_WINDOW_COL;
    }

    public void setMetaTable(@NotNull String metaTable) {
        this.metaTable = metaTable;
    }

    public void setMetaTableAppIdColumn(@NotNull String appIdColumn) {
        this.metaTableAppIdColumn = appIdColumn;
    }

    public void setMetaTableOperatorIdColumn(@NotNull String operatorIdColumn) {
        this.metaTableOperatorIdColumn = operatorIdColumn;
    }

    public void setMetaTableWindowColumn(@NotNull String windowColumn) {
        this.metaTableWindowColumn = windowColumn;
    }

    @Override
    public void connect() {
        super.connect();
        try {
            String command = "select " + this.metaTableWindowColumn + " from " + this.metaTable + " where " + this.metaTableAppIdColumn + " = ? and " + this.metaTableOperatorIdColumn + " = ?";
            logger.debug(command);
            this.lastWindowFetchCommand = this.connection.prepareStatement(command);
            command = "insert into " + this.metaTable + " (" + this.metaTableAppIdColumn + ", " + this.metaTableOperatorIdColumn + ", " + this.metaTableWindowColumn + ") values (?,?,?)";
            logger.debug(command);
            this.lastWindowInsertCommand = this.connection.prepareStatement(command);
            command = "update " + this.metaTable + " set " + this.metaTableWindowColumn + " = ? where " + this.metaTableAppIdColumn + " = ? " + " and " + this.metaTableOperatorIdColumn + " = ?";
            logger.debug(command);
            this.lastWindowUpdateCommand = this.connection.prepareStatement(command);
            command = "delete from " + this.metaTable + " where " + this.metaTableAppIdColumn + " = ? and " + this.metaTableOperatorIdColumn + " = ?";
            logger.debug(command);
            this.lastWindowDeleteCommand = this.connection.prepareStatement(command);
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void disconnect() {
        if (this.lastWindowUpdateCommand != null) {
            try {
                this.lastWindowUpdateCommand.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        super.disconnect();
    }

    @Override
    public void beginTransaction() {
        this.inTransaction = true;
    }

    @Override
    public void commitTransaction() {
        try {
            this.connection.commit();
            this.inTransaction = false;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rollbackTransaction() {
        try {
            this.connection.rollback();
            this.inTransaction = false;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isInTransaction() {
        return this.inTransaction;
    }

    @Override
    public long getCommittedWindowId(String appId, int operatorId) {
        Long lastWindow = this.getCommittedWindowIdHelper(appId, operatorId);
        try {
            if (lastWindow == null) {
                this.lastWindowInsertCommand.close();
                this.connection.commit();
            }
            this.lastWindowFetchCommand.close();
            LOG.debug("Last window id: {}", (Object)lastWindow);
            if (lastWindow == null) {
                return -1L;
            }
            return lastWindow;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Long getCommittedWindowIdHelper(String appId, int operatorId) {
        try {
            this.lastWindowFetchCommand.setString(1, appId);
            this.lastWindowFetchCommand.setInt(2, operatorId);
            Long lastWindow = null;
            ResultSet resultSet = this.lastWindowFetchCommand.executeQuery();
            if (resultSet.next()) {
                lastWindow = resultSet.getLong(1);
            } else {
                this.lastWindowInsertCommand.setString(1, appId);
                this.lastWindowInsertCommand.setInt(2, operatorId);
                this.lastWindowInsertCommand.setLong(3, -1L);
                this.lastWindowInsertCommand.executeUpdate();
            }
            return lastWindow;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void storeCommittedWindowId(String appId, int operatorId, long windowId) {
        try {
            this.lastWindowUpdateCommand.setLong(1, windowId);
            this.lastWindowUpdateCommand.setString(2, appId);
            this.lastWindowUpdateCommand.setInt(3, operatorId);
            this.lastWindowUpdateCommand.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeCommittedWindowId(String appId, int operatorId) {
        try {
            this.lastWindowDeleteCommand.setString(1, appId);
            this.lastWindowDeleteCommand.setInt(2, operatorId);
            this.lastWindowDeleteCommand.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

