/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.expression;

import com.datatorrent.lib.expression.Expression;
import com.datatorrent.lib.util.KeyValPair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaExpressionParser
implements Expression.ExpressionParser {
    private static final Logger logger = LoggerFactory.getLogger(JavaExpressionParser.class);
    private static final String GET = "get";
    private static final String IS = "is";
    private final String variablePlaceholderPattern = "\\{(.*?)\\}";
    private String exprObjPlaceholder;
    private String codeObjPlaceholder;

    @Override
    public String convertToCompilableExpression(String expression, Class<?> objectType, Class<?> returnType) {
        if (expression.startsWith(".")) {
            expression = expression.substring(1);
        }
        if (expression.isEmpty()) {
            throw new IllegalArgumentException("The getter expression: \"" + expression + "\" is invalid.");
        }
        Pattern entry = Pattern.compile("\\{(.*?)\\}");
        Matcher matcher = entry.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.groupCount() == 1) {
                matcher.appendReplacement(sb, this.getObjectJavaExpression(matcher.group(1), objectType));
                continue;
            }
            throw new RuntimeException("Invalid expression: " + matcher.group());
        }
        matcher.appendTail(sb);
        if (sb.toString().equals(expression)) {
            if (!expression.startsWith(this.exprObjPlaceholder + ".")) {
                expression = this.exprObjPlaceholder + "." + expression;
            }
            String tempExpr = this.getObjectJavaExpression(expression, objectType);
            sb.setLength(0);
            sb.append(tempExpr.replace("\\$", "$"));
        }
        return "return ((" + returnType.getName().replace("$", "\\$") + ")" + sb.toString() + ");";
    }

    @Override
    public void setInputObjectPlaceholder(String exprObjPlaceholder, String codeObjPlaceholder) {
        this.exprObjPlaceholder = exprObjPlaceholder;
        this.codeObjPlaceholder = codeObjPlaceholder;
    }

    private String getObjectJavaExpression(String exp, Class objectType) {
        StringBuilder sb = new StringBuilder();
        String[] split = exp.split("\\.");
        Class currentClassType = objectType;
        boolean first = true;
        for (String field : split) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            if (field.equals(this.exprObjPlaceholder)) {
                sb.append("((").append(objectType.getName().replace("$", "\\$")).append(")").append("(").append(this.codeObjPlaceholder).append("))");
                currentClassType = objectType;
                continue;
            }
            KeyValPair<String, Class<?>> getter = this.getGetterForVariable(field, currentClassType);
            sb.append((String)getter.getKey());
            currentClassType = (Class)getter.getValue();
        }
        return sb.toString();
    }

    private KeyValPair<String, ? extends Class<?>> getGetterForVariable(String var, Class<?> inputClassType) {
        String[] methodAccessors;
        try {
            Field field = inputClassType.getField(var);
            if (Modifier.isPublic(field.getModifiers())) {
                return new KeyValPair(var, field.getType());
            }
            logger.debug("Field {} is not publicly accessible. Proceeding to locate a getter method.", (Object)var);
        }
        catch (NoSuchFieldException ex) {
            logger.debug("{} does not have field {}. Proceeding to locate a getter method.", (Object)inputClassType.getName(), (Object)var);
        }
        for (String m : methodAccessors = new String[]{GET, IS}) {
            String methodName = m + var.substring(0, 1).toUpperCase() + var.substring(1);
            try {
                Method method = inputClassType.getMethod(methodName, new Class[0]);
                if (Modifier.isPublic(method.getModifiers())) {
                    return new KeyValPair(methodName + "()", method.getReturnType());
                }
                logger.debug("Method {} of {} is not accessible. Proceeding to locate another getter method.", (Object)methodName, (Object)inputClassType.getName());
            }
            catch (NoSuchMethodException ex) {
                logger.debug("{} does not have method {}. Proceeding to locate another getter method", (Object)inputClassType.getName(), (Object)methodName);
            }
        }
        return new KeyValPair(var, inputClassType);
    }
}

