/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.fileaccess;

import com.datatorrent.lib.fileaccess.FileAccess;
import com.datatorrent.netlet.util.Slice;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.file.tfile.DTFile;

@InterfaceStability.Evolving
public class DTFileReader
implements FileAccess.FileReader {
    private final DTFile.Reader reader;
    private final DTFile.Reader.Scanner scanner;
    private final FSDataInputStream fsdis;

    public DTFileReader(FSDataInputStream fsdis, long fileLength, Configuration conf) throws IOException {
        this.fsdis = fsdis;
        this.reader = new DTFile.Reader(fsdis, fileLength, conf);
        this.scanner = this.reader.createScanner();
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
        this.reader.close();
        this.fsdis.close();
    }

    @Override
    public void readFully(TreeMap<Slice, Slice> data) throws IOException {
        this.scanner.rewind();
        while (!this.scanner.atEnd()) {
            DTFile.Reader.Scanner.Entry en = this.scanner.entry();
            Slice key = new Slice(en.getBlockBuffer(), en.getKeyOffset(), en.getKeyLength());
            Slice value = new Slice(en.getBlockBuffer(), en.getValueOffset(), en.getValueLength());
            data.put(key, value);
            this.scanner.advance();
        }
    }

    @Override
    public void reset() throws IOException {
        this.scanner.rewind();
    }

    @Override
    public boolean seek(Slice key) throws IOException {
        return this.scanner.seekTo(key.buffer, key.offset, key.length);
    }

    @Override
    public boolean next(Slice key, Slice value) throws IOException {
        if (this.scanner.atEnd()) {
            return false;
        }
        DTFile.Reader.Scanner.Entry en = this.scanner.entry();
        key.buffer = en.getBlockBuffer();
        key.offset = en.getKeyOffset();
        key.length = en.getKeyLength();
        value.buffer = en.getBlockBuffer();
        value.offset = en.getValueOffset();
        value.length = en.getValueLength();
        this.scanner.advance();
        return true;
    }
}

