/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.fileaccess;

import com.datatorrent.lib.fileaccess.FileAccess;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import java.net.URI;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

@InterfaceStability.Evolving
public abstract class FileAccessFSImpl
implements FileAccess {
    @NotNull
    private String basePath;
    protected transient FileSystem fs;

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String path) {
        this.basePath = path;
    }

    protected Path getFilePath(long bucketKey, String fileName) {
        return new Path(this.getBucketPath(bucketKey), fileName);
    }

    protected Path getBucketPath(long bucketKey) {
        return new Path(this.basePath, Long.toString(bucketKey));
    }

    @Override
    public long getFileSize(long bucketKey, String fileName) throws IOException {
        return this.fs.getFileStatus(this.getFilePath(bucketKey, fileName)).getLen();
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }

    @Override
    public void init() {
        if (this.fs == null) {
            Path dataFilePath = new Path(this.basePath);
            try {
                this.fs = FileSystem.newInstance((URI)dataFilePath.toUri(), (Configuration)new Configuration());
            }
            catch (IOException e) {
                DTThrowable.rethrow((Exception)e);
            }
        }
    }

    @Override
    public void delete(long bucketKey, String fileName) throws IOException {
        this.fs.delete(this.getFilePath(bucketKey, fileName), true);
    }

    public FSDataOutputStream getOutputStream(long bucketKey, String fileName) throws IOException {
        Path path = this.getFilePath(bucketKey, fileName);
        return this.fs.create(path, true);
    }

    public FSDataInputStream getInputStream(long bucketKey, String fileName) throws IOException {
        return this.fs.open(this.getFilePath(bucketKey, fileName));
    }

    @Override
    public void rename(long bucketKey, String fromName, String toName) throws IOException {
        FileContext fc = FileContext.getFileContext((URI)this.fs.getUri());
        Path bucketPath = this.getBucketPath(bucketKey);
        if (!bucketPath.isAbsolute()) {
            bucketPath = new Path(this.fs.getWorkingDirectory(), bucketPath);
        }
        fc.rename(new Path(bucketPath, fromName), new Path(bucketPath, toName), new Options.Rename[]{Options.Rename.OVERWRITE});
    }

    @Override
    public boolean exists(long bucketKey, String fileName) throws IOException {
        return this.fs.exists(this.getFilePath(bucketKey, fileName));
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listFiles(long bucketKey) throws IOException {
        Path bucketPath = this.getBucketPath(bucketKey);
        return this.fs.exists(bucketPath) ? this.fs.listFiles(bucketPath, true) : null;
    }

    @Override
    public void deleteBucket(long bucketKey) throws IOException {
        this.fs.delete(this.getBucketPath(bucketKey), true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[basePath=" + this.basePath + "]";
    }
}

