/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.fileaccess;

import com.datatorrent.lib.fileaccess.DTFileReader;
import com.datatorrent.lib.fileaccess.FileAccess;
import com.datatorrent.lib.fileaccess.FileAccessFSImpl;
import com.datatorrent.lib.fileaccess.TFileReader;
import com.datatorrent.lib.fileaccess.TFileWriter;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;

@InterfaceStability.Evolving
public abstract class TFileImpl
extends FileAccessFSImpl {
    private int minBlockSize = 65536;
    private String compressName = "none";
    private String comparator = "memcmp";
    private int chunkSize = 0x100000;
    private int inputBufferSize = 262144;
    private int outputBufferSize = 262144;

    private void setupConfig(Configuration conf) {
        conf.set("tfile.io.chunk.size", String.valueOf(this.chunkSize));
        conf.set("tfile.fs.input.buffer.size", String.valueOf(this.inputBufferSize));
        conf.set("tfile.fs.output.buffer.size", String.valueOf(this.outputBufferSize));
    }

    @Override
    public FileAccess.FileWriter getWriter(long bucketKey, String fileName) throws IOException {
        FSDataOutputStream fsdos = this.getOutputStream(bucketKey, fileName);
        this.setupConfig(this.fs.getConf());
        return new TFileWriter(fsdos, this.minBlockSize, this.compressName, this.comparator, this.fs.getConf());
    }

    public int getMinBlockSize() {
        return this.minBlockSize;
    }

    public void setMinBlockSize(int minBlockSize) {
        this.minBlockSize = minBlockSize;
    }

    public String getCompressName() {
        return this.compressName;
    }

    public void setCompressName(String compressName) {
        this.compressName = compressName;
    }

    public String getComparator() {
        return this.comparator;
    }

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    public static class DTFileImpl
    extends TFileImpl {
        @Override
        public FileAccess.FileReader getReader(long bucketKey, String fileName) throws IOException {
            FSDataInputStream fsdis = this.getInputStream(bucketKey, fileName);
            long fileLength = this.getFileSize(bucketKey, fileName);
            ((TFileImpl)this).setupConfig(this.fs.getConf());
            return new DTFileReader(fsdis, fileLength, this.fs.getConf());
        }
    }

    public static class DefaultTFileImpl
    extends TFileImpl {
        @Override
        public FileAccess.FileReader getReader(long bucketKey, String fileName) throws IOException {
            FSDataInputStream fsdis = this.getInputStream(bucketKey, fileName);
            long fileLength = this.getFileSize(bucketKey, fileName);
            ((TFileImpl)this).setupConfig(this.fs.getConf());
            return new TFileReader(fsdis, fileLength, this.fs.getConf());
        }
    }
}

