/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.fileaccess;

import com.datatorrent.lib.fileaccess.FileAccess;
import com.datatorrent.netlet.util.Slice;
import java.io.IOException;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.file.tfile.TFile;

@InterfaceStability.Evolving
public class TFileReader
implements FileAccess.FileReader {
    private final TFile.Reader reader;
    private final TFile.Reader.Scanner scanner;
    private final FSDataInputStream fsdis;
    private boolean closed = false;

    public TFileReader(FSDataInputStream fsdis, long fileLength, Configuration conf) throws IOException {
        this.fsdis = fsdis;
        this.reader = new TFile.Reader(fsdis, fileLength, conf);
        this.scanner = this.reader.createScanner();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.scanner.close();
        this.reader.close();
        this.fsdis.close();
    }

    @Override
    public void readFully(TreeMap<Slice, Slice> data) throws IOException {
        this.scanner.rewind();
        while (!this.scanner.atEnd()) {
            TFile.Reader.Scanner.Entry en = this.scanner.entry();
            int klen = en.getKeyLength();
            int vlen = en.getValueLength();
            byte[] key = new byte[klen];
            byte[] value = new byte[vlen];
            en.getKey(key);
            en.getValue(value);
            data.put(new Slice(key, 0, key.length), new Slice(value, 0, value.length));
            this.scanner.advance();
        }
    }

    @Override
    public void reset() throws IOException {
        this.scanner.rewind();
    }

    @Override
    public boolean seek(Slice key) throws IOException {
        try {
            return this.scanner.seekTo(key.buffer, key.offset, key.length);
        }
        catch (NullPointerException ex) {
            if (this.closed) {
                throw new IOException("Stream was closed");
            }
            throw ex;
        }
    }

    @Override
    public boolean next(Slice key, Slice value) throws IOException {
        if (this.scanner.atEnd()) {
            return false;
        }
        TFile.Reader.Scanner.Entry en = this.scanner.entry();
        byte[] rkey = new byte[en.getKeyLength()];
        byte[] rval = new byte[en.getValueLength()];
        en.getKey(rkey);
        en.getValue(rval);
        key.buffer = rkey;
        key.offset = 0;
        key.length = en.getKeyLength();
        value.buffer = rval;
        value.offset = 0;
        value.length = en.getValueLength();
        this.scanner.advance();
        return true;
    }
}

