/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.formatter;

import com.datatorrent.api.Context;
import com.datatorrent.lib.formatter.Formatter;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.hadoop.classification.InterfaceStability;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class JsonFormatter
extends Formatter<String> {
    private transient ObjectWriter writer;
    protected String dateFormat;
    private static final Logger logger = LoggerFactory.getLogger(JsonFormatter.class);

    public void setup(Context.OperatorContext context) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            if (this.dateFormat != null) {
                mapper.setDateFormat((DateFormat)new SimpleDateFormat(this.dateFormat));
            }
            this.writer = mapper.writerWithType(this.clazz);
            mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
            mapper.configure(SerializationConfig.Feature.AUTO_DETECT_GETTERS, true);
            mapper.configure(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS, true);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable find provided class");
        }
    }

    @Override
    public String convert(Object tuple) {
        try {
            return this.writer.writeValueAsString(tuple);
        }
        catch (JsonGenerationException | JsonMappingException e) {
            logger.debug("Error while converting tuple {} {}", tuple, (Object)e.getMessage());
        }
        catch (IOException e) {
            DTThrowable.rethrow((Exception)e);
        }
        return null;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

