/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.formatter;

import com.datatorrent.api.Context;
import com.datatorrent.lib.formatter.Formatter;
import com.datatorrent.netlet.util.DTThrowable;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class XmlFormatter
extends Formatter<String> {
    protected String alias = null;
    protected String dateFormat = null;
    protected boolean prettyPrint;
    private transient Marshaller marshaller;
    private static final Logger logger = LoggerFactory.getLogger(XmlFormatter.class);

    public void setup(Context.OperatorContext context) {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{this.getClazz()});
            this.marshaller = ctx.createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", (Object)true);
            this.marshaller.setProperty("jaxb.formatted.output", (Object)this.prettyPrint);
        }
        catch (JAXBException e) {
            DTThrowable.wrapIfChecked((Exception)((Object)e));
        }
    }

    @Override
    public String convert(Object tuple) {
        try {
            StringWriter writer = new StringWriter();
            if (this.getAlias() != null) {
                this.marshaller.marshal((Object)new JAXBElement(new QName(this.getAlias()), tuple.getClass(), tuple), (Writer)writer);
            } else {
                this.marshaller.marshal((Object)new JAXBElement(new QName(this.getClazz().getSimpleName()), tuple.getClass(), tuple), (Writer)writer);
            }
            return writer.toString();
        }
        catch (Exception e) {
            logger.debug("Error while converting tuple {} {} ", tuple, (Object)e.getMessage());
            return null;
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }
}

