/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.lib.io.SimpleSinglePortInputOperator;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public abstract class AbstractHttpInputOperator<T>
extends SimpleSinglePortInputOperator<T>
implements Runnable {
    public final transient DefaultOutputPort<String> rawOutput = new DefaultOutputPort();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpInputOperator.class);
    public int readTimeoutMillis = 0;
    @NotNull
    private URI url;
    private Map<String, String> headers = new HashMap<String, String>();
    private transient Client wsClient;
    private transient WebResource resource;

    public void setUrl(URI u) {
        this.url = u;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setup(Context.OperatorContext context) {
        this.wsClient = Client.create();
        this.wsClient.setFollowRedirects(Boolean.valueOf(true));
        this.wsClient.setReadTimeout(Integer.valueOf(this.readTimeoutMillis));
        this.resource = this.wsClient.resource(this.url.toString());
        LOG.info("URL: {}", (Object)this.url);
    }

    public void teardown() {
        if (this.wsClient != null) {
            this.wsClient.destroy();
        }
        super.teardown();
    }

    public abstract void processResponse(ClientResponse var1) throws IOException;

    @Override
    public void run() {
        while (super.isActive()) {
            try {
                WebResource.Builder builder = this.resource.getRequestBuilder();
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    builder = (WebResource.Builder)builder.header(entry.getKey(), (Object)entry.getValue());
                }
                ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
                this.processResponse(response);
            }
            catch (Exception e) {
                LOG.error("Error reading from " + this.resource.getURI(), (Throwable)e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.info("Exiting IO loop {}.", (Object)e.toString());
                break;
            }
        }
    }
}

