/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.InputOperator;
import com.datatorrent.api.Operator;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public abstract class AbstractSocketInputOperator<T>
implements InputOperator,
Operator.ActivationListener<Context.OperatorContext> {
    private String hostname;
    private int port;
    private int scanIntervalInMilliSeconds = 1000;
    private int byteBufferSize = 1024;
    private transient Selector selector;
    private transient SocketChannel channel;
    private transient SelectionKey key;
    private transient Thread scanThread = new Thread(new SelectorScanner());
    private transient ByteBuffer byteBuffer;
    private transient Lock lock;
    public final transient DefaultOutputPort<T> outputPort = new DefaultOutputPort();

    public int getByteBufferSize() {
        return this.byteBufferSize;
    }

    public void setByteBufferSize(int byteBufferSize) {
        this.byteBufferSize = byteBufferSize;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getScanIntervalInMilliSeconds() {
        return this.scanIntervalInMilliSeconds;
    }

    public void setScanIntervalInMilliSeconds(int scanIntervalInMilliSeconds) {
        this.scanIntervalInMilliSeconds = scanIntervalInMilliSeconds;
    }

    public void emitTuples() {
        this.lock.lock();
        this.byteBuffer.flip();
        this.processBytes(this.byteBuffer);
        this.byteBuffer.flip();
        this.byteBuffer.clear();
        this.lock.unlock();
    }

    public abstract void processBytes(ByteBuffer var1);

    public void beginWindow(long l) {
    }

    public void endWindow() {
    }

    public void setup(Context.OperatorContext operatorContext) {
    }

    public void teardown() {
    }

    public void activate(Context.OperatorContext operatorContext) {
        try {
            this.selector = Selector.open();
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.channel.connect(new InetSocketAddress(this.hostname, this.port));
            this.channel.register(this.selector, 9);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.lock = new ReentrantLock();
        this.scanThread.start();
        this.byteBuffer = ByteBuffer.allocate(this.byteBufferSize);
    }

    public void deactivate() {
        try {
            this.channel.close();
            this.selector.close();
            this.scanThread.interrupt();
            this.scanThread.join();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public class SelectorScanner
    implements Runnable {
        @Override
        public void run() {
            boolean acquiredLock = false;
            try {
                while (true) {
                    AbstractSocketInputOperator.this.selector.select();
                    Set<SelectionKey> selectedKeys = AbstractSocketInputOperator.this.selector.selectedKeys();
                    Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
                    while (keyIterator.hasNext()) {
                        SocketChannel sChannel;
                        SelectionKey nextKey = keyIterator.next();
                        keyIterator.remove();
                        if (nextKey.isConnectable()) {
                            sChannel = (SocketChannel)nextKey.channel();
                            sChannel.finishConnect();
                        }
                        if (!nextKey.isReadable()) continue;
                        sChannel = (SocketChannel)nextKey.channel();
                        AbstractSocketInputOperator.this.lock.lock();
                        acquiredLock = true;
                        sChannel.read(AbstractSocketInputOperator.this.byteBuffer);
                        AbstractSocketInputOperator.this.lock.unlock();
                        acquiredLock = false;
                    }
                    Thread.sleep(AbstractSocketInputOperator.this.scanIntervalInMilliSeconds);
                }
            }
            catch (Exception e) {
                if (acquiredLock) {
                    AbstractSocketInputOperator.this.lock.unlock();
                }
                return;
            }
        }
    }
}

