/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.common.util.BaseOperator;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class MapMultiConsoleOutputOperator<K, V>
extends BaseOperator {
    private boolean debug = false;
    private static final Logger logger = LoggerFactory.getLogger(MapMultiConsoleOutputOperator.class);
    public final transient DefaultInputPort<Map<K, V>> input = new DefaultInputPort<Map<K, V>>(){

        public void process(Map<K, V> t) {
            System.out.println("{");
            for (Map.Entry entry : t.entrySet()) {
                if (!MapMultiConsoleOutputOperator.this.silent) {
                    System.out.println(entry.getKey().toString() + "=" + entry.getValue().toString());
                }
                if (!MapMultiConsoleOutputOperator.this.debug) continue;
                logger.info(entry.getKey().toString() + "=" + entry.getValue().toString());
            }
            System.out.println("}");
        }
    };
    boolean silent = false;

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }
}

