/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io;

import com.datatorrent.api.Context;
import com.datatorrent.common.experimental.AppData;
import com.datatorrent.common.util.PubSubMessage;
import com.datatorrent.lib.io.PubSubWebSocketAppDataQuery;
import com.datatorrent.lib.io.PubSubWebSocketOutputOperator;
import java.io.IOException;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AppData.AppendQueryIdToTopic(value=true)
public class PubSubWebSocketAppDataResult
extends PubSubWebSocketOutputOperator<String>
implements AppData.ConnectionInfoProvider {
    private static final Logger logger = LoggerFactory.getLogger(PubSubWebSocketAppDataResult.class);

    @Override
    public void setup(Context.OperatorContext context) {
        this.setUri(PubSubWebSocketAppDataQuery.uriHelper(context, this.getUri()));
        logger.debug("Setting up:\nuri:{}\ntopic:{}", (Object)this.getUri(), (Object)this.getTopic());
        super.setup(context);
    }

    public String getAppDataURL() {
        return "pubsub";
    }

    @Override
    public URI getUri() {
        return super.getUri();
    }

    @Override
    public void setUri(URI uri) {
        super.setUri(uri);
    }

    @Override
    public String convertMapToMessage(String t) throws IOException {
        String id;
        JSONObject jo = null;
        try {
            jo = new JSONObject(t);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        try {
            id = jo.getString("id");
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        String topic = this.getTopic() + "." + id;
        JSONObject output = new JSONObject();
        try {
            output.put("topic", (Object)topic);
            output.put("data", (Object)jo);
            output.put("type", (Object)PubSubMessage.PubSubMessageType.PUBLISH.getIdentifier());
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
        logger.debug("Output json {}", (Object)output.toString());
        logger.debug("Writing to topic: {}", (Object)topic);
        return output.toString();
    }
}

