/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.common.util.BaseOperator;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class SmtpOutputOperator
extends BaseOperator {
    private static final Logger LOG = LoggerFactory.getLogger(SmtpOutputOperator.class);
    @NotNull
    private String subject;
    @NotNull
    private String content;
    @NotNull
    private String from;
    private Map<String, String> recipients = Maps.newHashMap();
    private int smtpPort = 587;
    @NotNull
    private String smtpHost;
    private String smtpUserName;
    private String smtpPassword;
    private String contentType = "text/plain";
    private boolean useSsl = false;
    private boolean setupCalled = false;
    protected transient Properties properties = System.getProperties();
    protected transient Authenticator auth;
    protected transient Session session;
    protected transient Message message;
    public final transient DefaultInputPort<Object> input = new DefaultInputPort<Object>(){

        public void process(Object t) {
            try {
                String mailContent = SmtpOutputOperator.this.content.replace("{}", t.toString());
                SmtpOutputOperator.this.message.setContent((Object)mailContent, SmtpOutputOperator.this.contentType);
                LOG.info("Sending email for tuple {}", (Object)t.toString());
                Transport.send((Message)SmtpOutputOperator.this.message);
            }
            catch (MessagingException ex) {
                LOG.error("Something wrong with sending email.", (Throwable)ex);
            }
        }
    };

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
        this.resetMessage();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.resetMessage();
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
        this.resetMessage();
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
        this.reset();
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
        this.reset();
    }

    public String getSmtpUserName() {
        return this.smtpUserName;
    }

    public void setSmtpUserName(String smtpUserName) {
        this.smtpUserName = smtpUserName;
        this.reset();
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
        this.reset();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.resetMessage();
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
        this.reset();
    }

    public void setup(Context.OperatorContext context) {
        this.setupCalled = true;
        this.reset();
    }

    private void reset() {
        if (!this.setupCalled) {
            return;
        }
        if (!StringUtils.isBlank((String)this.smtpPassword)) {
            this.properties.setProperty("mail.smtp.auth", "true");
            this.properties.setProperty("mail.smtp.starttls.enable", "true");
            if (this.useSsl) {
                this.properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(this.smtpPort));
                this.properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                this.properties.setProperty("mail.smtp.socketFactory.fallback", "false");
            }
            this.auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SmtpOutputOperator.this.smtpUserName, SmtpOutputOperator.this.smtpPassword);
                }
            };
        }
        this.properties.setProperty("mail.smtp.host", this.smtpHost);
        this.properties.setProperty("mail.smtp.port", String.valueOf(this.smtpPort));
        this.session = Session.getInstance((Properties)this.properties, (Authenticator)this.auth);
        this.resetMessage();
    }

    private void resetMessage() {
        if (!this.setupCalled) {
            return;
        }
        try {
            this.message = new MimeMessage(this.session);
            this.message.setFrom((Address)new InternetAddress(this.from));
            for (Map.Entry<String, String> entry : this.recipients.entrySet()) {
                String[] addresses;
                Message.RecipientType recipientType;
                RecipientType type = RecipientType.valueOf(entry.getKey().toUpperCase());
                switch (type) {
                    case TO: {
                        recipientType = Message.RecipientType.TO;
                        break;
                    }
                    case CC: {
                        recipientType = Message.RecipientType.CC;
                        break;
                    }
                    default: {
                        recipientType = Message.RecipientType.BCC;
                    }
                }
                for (String address : addresses = entry.getValue().split(",")) {
                    this.message.addRecipient(recipientType, (Address)new InternetAddress(address));
                }
            }
            this.message.setSubject(this.subject);
            LOG.debug("all recipients {}", (Object)Arrays.toString(this.message.getAllRecipients()));
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map<String, String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(Map<String, String> recipients) {
        this.recipients = recipients;
        this.resetMessage();
    }

    @AssertTrue(message="Please verify the recipients set")
    private boolean isValid() {
        if (this.recipients.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.recipients.entrySet()) {
            if (!entry.getKey().toUpperCase().equalsIgnoreCase(RecipientType.TO.toString())) continue;
            return entry.getValue() != null && entry.getValue().length() > 0;
        }
        return false;
    }

    public static enum RecipientType {
        TO,
        CC,
        BCC;

    }
}

