/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io;

import com.datatorrent.api.Context;
import com.datatorrent.api.InputOperator;
import com.datatorrent.netlet.util.DTThrowable;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;

@InterfaceStability.Evolving
public abstract class WebSocketServerInputOperator
implements InputOperator {
    public static final String DEFAULT_EXTENSION = "/in";
    @Min(value=1L)
    private int port;
    @NotNull
    private String extension = "/in";
    private transient Server server;

    public void emitTuples() {
    }

    public void beginWindow(long windowId) {
    }

    public void endWindow() {
    }

    public void setup(Context.OperatorContext context) {
        this.server = new Server(this.port);
        DefaultWebSocketServlet servlet = new DefaultWebSocketServlet();
        ServletHolder sh = new ServletHolder((Servlet)servlet);
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 1);
        contextHandler.addServlet(sh, this.extension);
        try {
            this.server.start();
        }
        catch (Exception ex) {
            DTThrowable.rethrow((Exception)ex);
        }
    }

    public void teardown() {
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            DTThrowable.rethrow((Exception)ex);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public abstract void processMessage(String var1);

    private class DataSinkWebSocket
    implements WebSocket.OnTextMessage {
        public void onMessage(String data) {
            WebSocketServerInputOperator.this.processMessage(data);
        }

        public void onOpen(WebSocket.Connection connection) {
        }

        public void onClose(int closeCode, String message) {
        }
    }

    private class DefaultWebSocketServlet
    extends WebSocketServlet {
        private static final long serialVersionUID = 201503061010L;

        private DefaultWebSocketServlet() {
        }

        public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
            return new DataSinkWebSocket();
        }
    }
}

