/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.block;

import com.datatorrent.api.Context;
import com.datatorrent.api.StatsListener;
import com.datatorrent.lib.io.block.AbstractBlockReader;
import com.datatorrent.lib.io.block.BlockMetadata;
import com.datatorrent.lib.io.block.ReaderContext;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@StatsListener.DataQueueSize
public abstract class AbstractFSBlockReader<R>
extends AbstractBlockReader<R, BlockMetadata.FileBlockMetadata, FSDataInputStream> {
    protected transient FileSystem fs;
    protected transient Configuration configuration;
    protected String basePath;

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.configuration = new Configuration();
        try {
            this.fs = this.getFSInstance();
        }
        catch (IOException e) {
            throw new RuntimeException("creating fs", e);
        }
    }

    public void teardown() {
        super.teardown();
        try {
            this.fs.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected FSDataInputStream setupStream(BlockMetadata.FileBlockMetadata block) throws IOException {
        return this.fs.open(new Path(block.getFilePath()));
    }

    protected FileSystem getFSInstance() throws IOException {
        if (this.basePath != null) {
            return FileSystem.newInstance((URI)URI.create(this.basePath), (Configuration)this.configuration);
        }
        return FileSystem.newInstance((Configuration)this.configuration);
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public static abstract class AbstractFSReadAheadLineReader<R>
    extends AbstractFSBlockReader<R> {
        public AbstractFSReadAheadLineReader() {
            this.readerContext = new ReaderContext.ReadAheadLineReaderContext();
        }
    }

    public static abstract class AbstractFSLineReader<R>
    extends AbstractFSBlockReader<R> {
        public AbstractFSLineReader() {
            this.readerContext = new ReaderContext.LineReaderContext();
        }
    }
}

