/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.block;

import com.google.common.base.Preconditions;
import javax.validation.constraints.NotNull;

public interface BlockMetadata {
    public long getBlockId();

    public long getOffset();

    public long getLength();

    public boolean isLastBlock();

    public long getPreviousBlockId();

    public static class FileBlockMetadata
    extends AbstractBlockMetadata {
        private final String filePath;

        protected FileBlockMetadata() {
            this.filePath = null;
        }

        public FileBlockMetadata(String filePath, long blockId, long offset, long length, boolean isLastBlock, long previousBlockId) {
            super(blockId, offset, length, isLastBlock, previousBlockId);
            this.filePath = filePath;
        }

        public FileBlockMetadata(String filePath) {
            this.filePath = filePath;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public FileBlockMetadata newInstance(@NotNull String filePath) {
            Preconditions.checkNotNull((Object)filePath);
            return new FileBlockMetadata(filePath);
        }
    }

    public static abstract class AbstractBlockMetadata
    implements BlockMetadata {
        private long offset;
        private long length;
        private boolean isLastBlock;
        private long previousBlockId;
        private long blockId;

        protected AbstractBlockMetadata() {
            this.offset = -1L;
            this.length = -1L;
            this.isLastBlock = false;
            this.previousBlockId = -1L;
            this.blockId = -1L;
        }

        @Deprecated
        public AbstractBlockMetadata(long offset, long length, boolean isLastBlock, long previousBlockId) {
            this.offset = offset;
            this.length = length;
            this.isLastBlock = isLastBlock;
            this.previousBlockId = previousBlockId;
            this.blockId = -1L;
        }

        public AbstractBlockMetadata(long blockId, long offset, long length, boolean isLastBlock, long previousBlockId) {
            this.blockId = blockId;
            this.offset = offset;
            this.length = length;
            this.isLastBlock = isLastBlock;
            this.previousBlockId = previousBlockId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractBlockMetadata)) {
                return false;
            }
            AbstractBlockMetadata that = (AbstractBlockMetadata)o;
            return this.getBlockId() == that.getBlockId();
        }

        public int hashCode() {
            return (int)this.getBlockId();
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        @Override
        public boolean isLastBlock() {
            return this.isLastBlock;
        }

        public void setLastBlock(boolean lastBlock) {
            this.isLastBlock = lastBlock;
        }

        @Override
        public long getPreviousBlockId() {
            return this.previousBlockId;
        }

        public void setPreviousBlockId(long previousBlockId) {
            this.previousBlockId = previousBlockId;
        }

        @Override
        public long getBlockId() {
            return this.blockId;
        }

        public void setBlockId(long blockId) {
            this.blockId = blockId;
        }
    }
}

