/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.block;

import com.datatorrent.lib.io.block.BlockMetadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PositionedReadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ReaderContext<STREAM extends InputStream> {
    public void initialize(STREAM var1, BlockMetadata var2, boolean var3);

    public Entity next() throws IOException;

    public static class FixedBytesReaderContext<STREAM extends InputStream>
    extends AbstractReaderContext<STREAM> {
        protected Integer length;
        private static final Logger LOG = LoggerFactory.getLogger(FixedBytesReaderContext.class);

        @Override
        public void initialize(STREAM stream, BlockMetadata blockMetadata, boolean consecutiveBlock) {
            if (this.length == null) {
                this.length = (int)new Configuration().getLong("fs.local.block.size", 0x2000000L);
                LOG.debug("length init {}", (Object)this.length);
            }
            super.initialize(stream, blockMetadata, consecutiveBlock);
        }

        @Override
        protected Entity readEntity() throws IOException {
            this.entity.clear();
            int bytesToRead = this.length;
            if (this.offset + (long)this.length.intValue() >= this.blockMetadata.getLength()) {
                bytesToRead = (int)(this.blockMetadata.getLength() - this.offset);
            }
            byte[] record = new byte[bytesToRead];
            ((PositionedReadable)this.stream).readFully(this.offset, record, 0, bytesToRead);
            this.entity.usedBytes = bytesToRead;
            Entity.access$102(this.entity, record);
            return this.entity;
        }

        public void setLength(Integer length) {
            this.length = length;
        }

        public Integer getLength() {
            return this.length;
        }
    }

    public static class ReadAheadLineReaderContext<STREAM extends InputStream>
    extends LineReaderContext<STREAM> {
        @Override
        public void initialize(STREAM stream, BlockMetadata blockMetadata, boolean consecutiveBlock) {
            super.initialize(stream, blockMetadata, consecutiveBlock);
            if (!consecutiveBlock && blockMetadata.getOffset() != 0L) {
                try {
                    Entity entity = this.readEntity();
                    this.offset += entity.usedBytes;
                }
                catch (IOException e) {
                    throw new RuntimeException("when reading first entity", e);
                }
            }
        }

        @Override
        public Entity next() throws IOException {
            if (this.offset < this.blockMetadata.getLength() || this.offset == this.blockMetadata.getLength() && !this.blockMetadata.isLastBlock()) {
                Entity entity = this.readEntity();
                this.offset += entity.usedBytes;
                return entity;
            }
            return null;
        }
    }

    public static class LineReaderContext<STREAM extends InputStream>
    extends AbstractReaderContext<STREAM> {
        protected int bufferSize = 8192;
        private final transient ByteArrayOutputStream lineBuilder = new ByteArrayOutputStream();
        private final transient ByteArrayOutputStream emptyBuilder = new ByteArrayOutputStream();
        private final transient ByteArrayOutputStream tmpBuilder = new ByteArrayOutputStream();
        private transient byte[] buffer;
        private transient String strBuffer;
        private transient int posInStr;

        @Override
        public void initialize(STREAM stream, BlockMetadata blockMetadata, boolean consecutiveBlock) {
            if (this.buffer == null) {
                this.buffer = new byte[this.bufferSize];
            }
            super.initialize(stream, blockMetadata, consecutiveBlock);
        }

        @Override
        protected Entity readEntity() throws IOException {
            boolean foundEOL = false;
            int bytesRead = 0;
            long usedBytes = 0L;
            while (!foundEOL) {
                this.tmpBuilder.reset();
                if (this.posInStr == 0) {
                    bytesRead = ((PositionedReadable)this.stream).read(this.offset + usedBytes, this.buffer, 0, this.bufferSize);
                    if (bytesRead == -1) break;
                    this.strBuffer = new String(this.buffer);
                }
                while (this.posInStr < this.strBuffer.length()) {
                    char c = this.strBuffer.charAt(this.posInStr);
                    if (c != '\r' && c != '\n') {
                        this.tmpBuilder.write(c);
                        ++this.posInStr;
                        continue;
                    }
                    foundEOL = true;
                    break;
                }
                byte[] subLine = this.tmpBuilder.toByteArray();
                usedBytes += (long)subLine.length;
                this.lineBuilder.write(subLine);
                if (foundEOL) {
                    char c;
                    while (this.posInStr < this.strBuffer.length() && ((c = this.strBuffer.charAt(this.posInStr)) == '\r' || c == '\n')) {
                        this.emptyBuilder.write(c);
                        ++this.posInStr;
                    }
                    usedBytes += (long)this.emptyBuilder.toByteArray().length;
                    continue;
                }
                this.posInStr = 0;
            }
            this.posInStr = 0;
            if (bytesRead == -1) {
                this.lineBuilder.reset();
                this.emptyBuilder.reset();
                return null;
            }
            this.entity.clear();
            Entity.access$102(this.entity, this.lineBuilder.toByteArray());
            this.entity.usedBytes = usedBytes;
            this.lineBuilder.reset();
            this.emptyBuilder.reset();
            return this.entity;
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }
    }

    public static abstract class AbstractReaderContext<STREAM extends InputStream>
    implements ReaderContext<STREAM> {
        protected transient long offset = -1L;
        protected transient STREAM stream;
        protected transient BlockMetadata blockMetadata;
        protected final transient Entity entity = new Entity();

        protected AbstractReaderContext() {
        }

        @Override
        public void initialize(STREAM stream, BlockMetadata blockMetadata, boolean consecutiveBlock) {
            this.stream = stream;
            this.blockMetadata = blockMetadata;
            if (!consecutiveBlock) {
                this.offset = blockMetadata.getOffset();
            }
        }

        @Override
        public Entity next() throws IOException {
            if (this.offset < this.blockMetadata.getLength()) {
                Entity entity = this.readEntity();
                this.offset += entity.usedBytes;
                return entity;
            }
            return null;
        }

        protected abstract Entity readEntity() throws IOException;
    }

    public static class Entity {
        private byte[] record;
        private long usedBytes;

        public void clear() {
            this.record = null;
            this.usedBytes = -1L;
        }

        public byte[] getRecord() {
            return this.record;
        }

        public void setRecord(byte[] record) {
            this.record = record;
        }

        public long getUsedBytes() {
            return this.usedBytes;
        }

        public void setUsedBytes(long usedBytes) {
            this.usedBytes = usedBytes;
        }

        static /* synthetic */ byte[] access$102(Entity x0, byte[] x1) {
            x0.record = x1;
            return x1;
        }
    }
}

