/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.lib.io.block.BlockMetadata;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public abstract class AbstractFileSplitter
extends BaseOperator {
    protected Long blockSize;
    private int sequenceNo;
    @Min(value=1L)
    protected int blocksThreshold;
    protected transient long blockCount;
    protected BlockMetadataIterator blockMetadataIterator;
    protected transient int operatorId;
    protected transient Context.OperatorContext context;
    protected transient long currentWindowId;
    @AutoMetric
    protected int filesProcessed;
    public final transient DefaultOutputPort<FileMetadata> filesMetadataOutput = new DefaultOutputPort();
    public final transient DefaultOutputPort<BlockMetadata.FileBlockMetadata> blocksMetadataOutput = new DefaultOutputPort();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileSplitter.class);

    public AbstractFileSplitter() {
        this.blocksThreshold = Integer.MAX_VALUE;
    }

    public void setup(Context.OperatorContext context) {
        Preconditions.checkArgument((this.blockSize == null || this.blockSize > 0L ? 1 : 0) != 0, (Object)"invalid block size");
        this.operatorId = context.getId();
        this.context = context;
        this.currentWindowId = (Long)context.getValue(Context.OperatorContext.ACTIVATION_WINDOW_ID);
        if (this.blockSize == null) {
            this.blockSize = this.getDefaultBlockSize();
        }
    }

    public void beginWindow(long windowId) {
        this.filesProcessed = 0;
        this.blockCount = 0L;
        this.currentWindowId = windowId;
    }

    protected void process() {
        FileInfo fileInfo;
        if (this.blockMetadataIterator != null && this.blockCount < (long)this.blocksThreshold) {
            this.emitBlockMetadata();
        }
        while (this.blockCount < (long)this.blocksThreshold && (fileInfo = this.getFileInfo()) != null && this.processFileInfo(fileInfo)) {
        }
    }

    protected abstract FileInfo getFileInfo();

    protected boolean processFileInfo(FileInfo fileInfo) {
        try {
            FileMetadata fileMetadata = this.buildFileMetadata(fileInfo);
            this.filesMetadataOutput.emit((Object)fileMetadata);
            ++this.filesProcessed;
            if (!fileMetadata.isDirectory()) {
                this.blockMetadataIterator = new BlockMetadataIterator(this, fileMetadata, this.blockSize);
                if (!this.emitBlockMetadata()) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("creating metadata", e);
        }
    }

    protected boolean emitBlockMetadata() {
        while (this.blockMetadataIterator.hasNext()) {
            if (this.blockCount++ < (long)this.blocksThreshold) {
                this.blocksMetadataOutput.emit((Object)this.blockMetadataIterator.next());
                continue;
            }
            return false;
        }
        this.blockMetadataIterator = null;
        return true;
    }

    protected BlockMetadata.FileBlockMetadata buildBlockMetadata(long pos, long lengthOfFileInBlock, int blockNumber, FileMetadata fileMetadata, boolean isLast) {
        BlockMetadata.FileBlockMetadata fileBlockMetadata = this.createBlockMetadata(fileMetadata);
        fileBlockMetadata.setBlockId(fileMetadata.getBlockIds()[blockNumber - 1]);
        fileBlockMetadata.setOffset(pos);
        fileBlockMetadata.setLength(lengthOfFileInBlock);
        fileBlockMetadata.setLastBlock(isLast);
        fileBlockMetadata.setPreviousBlockId(blockNumber == 1 ? -1L : fileMetadata.getBlockIds()[blockNumber - 2]);
        return fileBlockMetadata;
    }

    protected BlockMetadata.FileBlockMetadata createBlockMetadata(FileMetadata fileMetadata) {
        return new BlockMetadata.FileBlockMetadata(fileMetadata.getFilePath());
    }

    protected FileMetadata buildFileMetadata(FileInfo fileInfo) throws IOException {
        LOG.debug("file {}", (Object)fileInfo.getFilePath());
        FileMetadata fileMetadata = this.createFileMetadata(fileInfo);
        LOG.debug("fileMetadata {}", (Object)fileMetadata);
        Path path = new Path(fileInfo.getFilePath());
        fileMetadata.setFileName(path.getName());
        FileStatus status = this.getFileStatus(path);
        fileMetadata.setDirectory(status.isDirectory());
        fileMetadata.setFileLength(status.getLen());
        if (fileInfo.getDirectoryPath() == null) {
            fileMetadata.setRelativePath(status.getPath().getName());
        } else {
            String relativePath = this.getRelativePathWithFolderName(fileInfo);
            fileMetadata.setRelativePath(relativePath);
        }
        if (!status.isDirectory()) {
            int noOfBlocks = (int)(status.getLen() / this.blockSize + (long)(status.getLen() % this.blockSize == 0L ? 0 : 1));
            if (fileMetadata.getDataOffset() >= status.getLen()) {
                noOfBlocks = 0;
            }
            fileMetadata.setNumberOfBlocks(noOfBlocks);
            this.populateBlockIds(fileMetadata);
        }
        return fileMetadata;
    }

    private String getRelativePathWithFolderName(FileInfo fileInfo) {
        String parentDir = new Path(fileInfo.getDirectoryPath()).getName();
        return parentDir + File.separator + fileInfo.getRelativeFilePath();
    }

    protected FileMetadata createFileMetadata(FileInfo fileInfo) {
        return new FileMetadata(fileInfo.getFilePath());
    }

    protected void populateBlockIds(FileMetadata fileMetadata) {
        long[] blockIds = new long[fileMetadata.getNumberOfBlocks()];
        long longLeftSide = (long)this.operatorId << 32;
        for (int i = 0; i < fileMetadata.getNumberOfBlocks(); ++i) {
            blockIds[i] = longLeftSide | (long)this.sequenceNo++ & 0xFFFFFFFFL;
        }
        fileMetadata.setBlockIds(blockIds);
    }

    protected abstract long getDefaultBlockSize();

    protected abstract FileStatus getFileStatus(Path var1) throws IOException;

    public void setBlockSize(Long blockSize) {
        this.blockSize = blockSize;
    }

    public Long getBlockSize() {
        return this.blockSize;
    }

    public void setBlocksThreshold(int threshold) {
        this.blocksThreshold = threshold;
    }

    public int getBlocksThreshold() {
        return this.blocksThreshold;
    }

    public static class FileInfo {
        protected final String directoryPath;
        protected final String relativeFilePath;

        protected FileInfo() {
            this.directoryPath = null;
            this.relativeFilePath = null;
        }

        public FileInfo(@Nullable String directoryPath, @NotNull String relativeFilePath) {
            this.directoryPath = directoryPath;
            this.relativeFilePath = relativeFilePath;
        }

        public String getDirectoryPath() {
            return this.directoryPath;
        }

        public String getRelativeFilePath() {
            return this.relativeFilePath;
        }

        public String getFilePath() {
            if (this.directoryPath == null) {
                return this.relativeFilePath;
            }
            return new Path(this.directoryPath, this.relativeFilePath).toUri().getPath();
        }
    }

    public static class FileMetadata {
        @NotNull
        private String filePath;
        private String fileName;
        private int numberOfBlocks;
        private long dataOffset;
        private long fileLength;
        private long discoverTime;
        private long[] blockIds;
        private boolean isDirectory;
        private String relativePath;

        protected FileMetadata() {
            this.filePath = null;
            this.discoverTime = System.currentTimeMillis();
        }

        public FileMetadata(@NotNull String filePath) {
            this.filePath = filePath;
            this.discoverTime = System.currentTimeMillis();
        }

        protected FileMetadata(FileMetadata fileMetadata) {
            this();
            this.filePath = fileMetadata.filePath;
            this.fileName = fileMetadata.fileName;
            this.numberOfBlocks = fileMetadata.numberOfBlocks;
            this.dataOffset = fileMetadata.dataOffset;
            this.fileLength = fileMetadata.fileLength;
            this.discoverTime = fileMetadata.discoverTime;
            this.blockIds = fileMetadata.blockIds;
            this.isDirectory = fileMetadata.isDirectory;
            this.relativePath = fileMetadata.relativePath;
        }

        public int getNumberOfBlocks() {
            return this.numberOfBlocks;
        }

        public void setNumberOfBlocks(int numberOfBlocks) {
            this.numberOfBlocks = numberOfBlocks;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public long getDataOffset() {
            return this.dataOffset;
        }

        public void setDataOffset(long offset) {
            this.dataOffset = offset;
        }

        public long getFileLength() {
            return this.fileLength;
        }

        public void setFileLength(long fileLength) {
            this.fileLength = fileLength;
        }

        public long getDiscoverTime() {
            return this.discoverTime;
        }

        public void setDiscoverTime(long discoverTime) {
            this.discoverTime = discoverTime;
        }

        public long[] getBlockIds() {
            return this.blockIds;
        }

        public void setBlockIds(long[] blockIds) {
            this.blockIds = blockIds;
        }

        public void setDirectory(boolean isDirectory) {
            this.isDirectory = isDirectory;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        public String toString() {
            return "FileMetadata [fileName=" + this.fileName + ", numberOfBlocks=" + this.numberOfBlocks + ", isDirectory=" + this.isDirectory + ", relativePath=" + this.relativePath + "]";
        }
    }

    protected static class BlockMetadataIterator
    implements Iterator<BlockMetadata.FileBlockMetadata> {
        private final FileMetadata fileMetadata;
        private final long blockSize;
        private long pos;
        private int blockNumber;
        private final AbstractFileSplitter splitter;

        protected BlockMetadataIterator() {
            this.fileMetadata = null;
            this.blockSize = -1L;
            this.splitter = null;
        }

        protected BlockMetadataIterator(AbstractFileSplitter splitter, FileMetadata fileMetadata, long blockSize) {
            this.splitter = splitter;
            this.fileMetadata = fileMetadata;
            this.blockSize = blockSize;
            this.pos = fileMetadata.getDataOffset();
            this.blockNumber = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.fileMetadata.getFileLength();
        }

        @Override
        public BlockMetadata.FileBlockMetadata next() {
            long length;
            while ((length = this.blockSize * (long)(++this.blockNumber)) <= this.pos) {
            }
            boolean isLast = length >= this.fileMetadata.getFileLength();
            long lengthOfFileInBlock = isLast ? this.fileMetadata.getFileLength() : length;
            BlockMetadata.FileBlockMetadata fileBlock = this.splitter.buildBlockMetadata(this.pos, lengthOfFileInBlock, this.blockNumber, this.fileMetadata, isLast);
            this.pos = lengthOfFileInBlock;
            return fileBlock;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

