/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.api.Context;
import com.datatorrent.lib.io.fs.AbstractFileOutputOperator;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSingleFileOutputOperator<INPUT>
extends AbstractFileOutputOperator<INPUT> {
    @NotNull
    protected String outputFileName;
    private String partitionedFileNameformat = "%s_%d";
    private transient String partitionedFileName;
    private transient int physicalPartitionId;

    @Override
    public void setup(Context.OperatorContext context) {
        super.setup(context);
        this.physicalPartitionId = context.getId();
        this.partitionedFileName = StringUtils.isEmpty((String)this.partitionedFileNameformat) ? this.outputFileName : String.format(this.partitionedFileNameformat, this.outputFileName, this.physicalPartitionId);
    }

    @Override
    protected String getFileName(INPUT tuple) {
        return this.partitionedFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String getPartitionedFileNameformat() {
        return this.partitionedFileNameformat;
    }

    public void setPartitionedFileNameformat(String partitionedFileNameformat) {
        this.partitionedFileNameformat = partitionedFileNameformat;
    }

    public String getPartitionedFileName() {
        return this.partitionedFileName;
    }
}

