/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.lib.io.fs.AbstractFileOutputOperator;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public abstract class AbstractWindowFileOutputOperator<INPUT>
extends AbstractFileOutputOperator<INPUT> {
    private transient String windowIdString;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWindowFileOutputOperator.class);

    public AbstractWindowFileOutputOperator() {
        this.maxOpenFiles = 1;
    }

    @Override
    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.windowIdString = Long.toString(windowId);
    }

    @Override
    public void endWindow() {
        this.endOffsets.remove(this.windowIdString);
        this.streamsCache.invalidate((Object)this.windowIdString);
    }

    @Override
    protected String getFileName(INPUT tuple) {
        return this.windowIdString;
    }

    @Override
    public void setMaxLength(long maxLength) {
        throw new UnsupportedOperationException("This property cannot be set on this operator.");
    }

    @Override
    public void setMaxOpenFiles(int maxOpenFiles) {
        throw new UnsupportedOperationException("This property cannot be set on this operator.");
    }
}

