/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.api.Module;
import com.datatorrent.api.Operator;
import com.datatorrent.common.partitioner.StatelessPartitioner;
import com.datatorrent.lib.codec.KryoSerializableStreamCodec;
import com.datatorrent.lib.io.block.AbstractBlockReader;
import com.datatorrent.lib.io.block.BlockMetadata;
import com.datatorrent.lib.io.block.FSSliceReader;
import com.datatorrent.lib.io.fs.AbstractFileSplitter;
import com.datatorrent.lib.io.fs.FileSplitterInput;
import com.datatorrent.netlet.util.Slice;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.hadoop.conf.Configuration;

public class FSInputModule
implements Module {
    @NotNull
    @Size(min=1)
    private String files;
    private String filePatternRegularExp;
    @Min(value=0L)
    private long scanIntervalMillis;
    private boolean recursive = true;
    private long blockSize;
    private boolean sequencialFileRead = false;
    private int readersCount;
    public final transient Module.ProxyOutputPort<AbstractFileSplitter.FileMetadata> filesMetadataOutput = new Module.ProxyOutputPort();
    public final transient Module.ProxyOutputPort<BlockMetadata.FileBlockMetadata> blocksMetadataOutput = new Module.ProxyOutputPort();
    public final transient Module.ProxyOutputPort<AbstractBlockReader.ReaderRecord<Slice>> messages = new Module.ProxyOutputPort();

    public FileSplitterInput createFileSplitter() {
        return new FileSplitterInput();
    }

    public FSSliceReader createBlockReader() {
        return new FSSliceReader();
    }

    public void populateDAG(DAG dag, Configuration conf) {
        FileSplitterInput fileSplitter = (FileSplitterInput)dag.addOperator("FileSplitter", (Operator)this.createFileSplitter());
        FSSliceReader blockReader = (FSSliceReader)dag.addOperator("BlockReader", (Operator)this.createBlockReader());
        dag.addStream("BlockMetadata", (Operator.OutputPort)fileSplitter.blocksMetadataOutput, (Operator.InputPort)blockReader.blocksMetadataInput);
        this.filesMetadataOutput.set((Operator.OutputPort)fileSplitter.filesMetadataOutput);
        this.blocksMetadataOutput.set((Operator.OutputPort)blockReader.blocksMetadataOutput);
        this.messages.set((Operator.OutputPort)blockReader.messages);
        if (this.sequencialFileRead) {
            dag.setInputPortAttribute((Operator.InputPort)blockReader.blocksMetadataInput, Context.PortContext.STREAM_CODEC, (Object)new SequentialFileBlockMetadataCodec());
        }
        if (this.blockSize != 0L) {
            fileSplitter.setBlockSize(this.blockSize);
        }
        FileSplitterInput.TimeBasedDirectoryScanner fileScanner = fileSplitter.getScanner();
        fileScanner.setFiles(this.files);
        if (this.scanIntervalMillis != 0L) {
            fileScanner.setScanIntervalMillis(this.scanIntervalMillis);
        }
        fileScanner.setRecursive(this.recursive);
        if (this.filePatternRegularExp != null) {
            fileSplitter.getScanner().setFilePatternRegularExp(this.filePatternRegularExp);
        }
        blockReader.setBasePath(this.files);
        if (this.readersCount != 0) {
            dag.setAttribute((Operator)blockReader, Context.OperatorContext.PARTITIONER, (Object)new StatelessPartitioner(this.readersCount));
            fileSplitter.setBlocksThreshold(this.readersCount);
        }
    }

    public void setFiles(String files) {
        this.files = files;
    }

    public String getFiles() {
        return this.files;
    }

    public String getFilePatternRegularExp() {
        return this.filePatternRegularExp;
    }

    public void setFilePatternRegularExp(String filePatternRegexp) {
        this.filePatternRegularExp = filePatternRegexp;
    }

    public long getScanIntervalMillis() {
        return this.scanIntervalMillis;
    }

    public void setScanIntervalMillis(long scanIntervalMillis) {
        this.scanIntervalMillis = scanIntervalMillis;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public int getReadersCount() {
        return this.readersCount;
    }

    public void setReadersCount(int readersCount) {
        this.readersCount = readersCount;
    }

    public boolean isSequencialFileRead() {
        return this.sequencialFileRead;
    }

    public void setSequencialFileRead(boolean sequencialFileRead) {
        this.sequencialFileRead = sequencialFileRead;
    }

    public static class SequentialFileBlockMetadataCodec
    extends KryoSerializableStreamCodec<BlockMetadata.FileBlockMetadata> {
        @Override
        public int getPartition(BlockMetadata.FileBlockMetadata fileBlockMetadata) {
            return fileBlockMetadata.hashCode();
        }
    }
}

