/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.api.AutoMetric;
import com.datatorrent.lib.io.fs.FileStitcher;
import com.datatorrent.lib.io.fs.Synchronizer;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;

public class FileMerger
extends FileStitcher<Synchronizer.OutputFileMetadata> {
    private boolean overwriteOnConflict = true;
    @AutoMetric
    private long bytesWritten;

    @Override
    public void beginWindow(long windowId) {
        super.beginWindow(windowId);
        this.bytesWritten = 0L;
    }

    @Override
    protected void mergeOutputFile(Synchronizer.OutputFileMetadata outputFileMetadata) throws IOException {
        LOG.debug("Processing file: {}", (Object)outputFileMetadata.getStitchedFileRelativePath());
        Path outputFilePath = new Path(this.filePath, outputFileMetadata.getStitchedFileRelativePath());
        if (outputFileMetadata.isDirectory()) {
            this.createDir(outputFilePath);
            this.successfulFiles.add(outputFileMetadata);
            return;
        }
        if (this.outputFS.exists(outputFilePath) && !this.overwriteOnConflict) {
            LOG.debug("Output file {} already exits and overwrite flag is off. Skipping.", (Object)outputFilePath);
            this.skippedFiles.add(outputFileMetadata);
            return;
        }
        super.mergeOutputFile(outputFileMetadata);
        this.deleteBlockFiles(outputFileMetadata);
    }

    private void deleteBlockFiles(Synchronizer.OutputFileMetadata outputFileMetadata) {
        if (outputFileMetadata.isDirectory()) {
            return;
        }
        for (long blockId : outputFileMetadata.getBlockIds()) {
            Path blockPath = new Path(this.blocksDirectoryPath, Long.toString(blockId));
            try {
                if (!this.appFS.exists(blockPath)) continue;
                this.appFS.delete(blockPath, false);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to delete block: " + blockId, e);
            }
        }
    }

    @Override
    protected OutputStream writeTempOutputFile(Synchronizer.OutputFileMetadata outputFileMetadata) throws IOException, FileStitcher.BlockNotFoundException {
        OutputStream outputStream = super.writeTempOutputFile(outputFileMetadata);
        this.bytesWritten += outputFileMetadata.getFileLength();
        return outputStream;
    }

    private void createDir(Path outputFilePath) throws IOException {
        if (!this.outputFS.exists(outputFilePath)) {
            this.outputFS.mkdirs(outputFilePath);
        }
    }

    @Override
    protected OutputStream getOutputStream(Path partFilePath) throws IOException {
        FSDataOutputStream outputStream = this.outputFS.create(partFilePath);
        return outputStream;
    }

    public boolean isOverwriteOnConflict() {
        return this.overwriteOnConflict;
    }

    public void setOverwriteOnConflict(boolean overwriteOnConflict) {
        this.overwriteOnConflict = overwriteOnConflict;
    }
}

