/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.lib.io.fs.AbstractFileSplitter;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FileSplitterBase
extends AbstractFileSplitter
implements Operator.IdleTimeHandler {
    @NotNull
    protected String file;
    protected transient FileSystem fs;
    protected final LinkedList<AbstractFileSplitter.FileInfo> fileInfos;
    protected transient int sleepTimeMillis;
    public final transient DefaultInputPort<AbstractFileSplitter.FileInfo> input = new DefaultInputPort<AbstractFileSplitter.FileInfo>(){

        public void process(AbstractFileSplitter.FileInfo fileInfo) {
            FileSplitterBase.this.fileInfos.add(fileInfo);
            FileSplitterBase.this.process();
        }
    };

    public FileSplitterBase() {
        this.fileInfos = new LinkedList();
    }

    @Override
    public void setup(Context.OperatorContext context) {
        this.sleepTimeMillis = (Integer)context.getValue(Context.OperatorContext.SPIN_MILLIS);
        try {
            this.fs = this.getFSInstance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.setup(context);
    }

    protected FileSystem getFSInstance() throws IOException {
        return FileSystem.newInstance((URI)new Path(this.file).toUri(), (Configuration)new Configuration());
    }

    @Override
    protected AbstractFileSplitter.FileInfo getFileInfo() {
        if (this.fileInfos.size() > 0) {
            return this.fileInfos.remove();
        }
        return null;
    }

    public void handleIdleTime() {
        if (this.blockCount < (long)this.blocksThreshold && (this.blockMetadataIterator != null || this.fileInfos.size() > 0)) {
            this.process();
        } else {
            try {
                Thread.sleep(this.sleepTimeMillis);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
    }

    public void teardown() {
        super.teardown();
        try {
            this.fs.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize(new Path(this.file));
    }

    @Override
    protected FileStatus getFileStatus(Path path) throws IOException {
        return this.fs.getFileStatus(path);
    }

    public void setFile(@NotNull String file) {
        this.file = (String)Preconditions.checkNotNull((Object)file, (Object)"file path");
    }

    public String getFile() {
        return this.file;
    }
}

