/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.lib.io.fs.FilterStreamContext;
import com.datatorrent.lib.io.fs.FilterStreamProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

public class FilterStreamCodec {

    public static class CipherSimpleStreamProvider
    implements FilterStreamProvider<CipherOutputStream, OutputStream> {
        private transient Cipher cipher;

        public Cipher getCipher() {
            return this.cipher;
        }

        public void setCipher(Cipher cipher) {
            this.cipher = cipher;
        }

        @Override
        public FilterStreamContext<CipherOutputStream> getFilterStreamContext(OutputStream outputStream) throws IOException {
            return new FilterStreamContext.SimpleFilterStreamContext<CipherOutputStream>(new CipherOutputStream(outputStream, this.cipher));
        }

        @Override
        public void reclaimFilterStreamContext(FilterStreamContext<CipherOutputStream> filterStreamContext) {
        }
    }

    public static class CipherFilterStreamContext
    extends FilterStreamContext.BaseFilterStreamContext<CipherOutputStream> {
        public CipherFilterStreamContext(OutputStream outputStream, Cipher cipher) throws IOException {
            this.filterStream = new CipherOutputStream(outputStream, cipher);
        }
    }

    public static class GZipFilterStreamProvider
    implements FilterStreamProvider<GZIPOutputStream, OutputStream> {
        @Override
        public FilterStreamContext<GZIPOutputStream> getFilterStreamContext(OutputStream outputStream) throws IOException {
            return new GZIPFilterStreamContext(outputStream);
        }

        @Override
        public void reclaimFilterStreamContext(FilterStreamContext<GZIPOutputStream> filterStreamContext) {
        }
    }

    public static class GZIPFilterStreamContext
    extends FilterStreamContext.BaseFilterStreamContext<GZIPOutputStream> {
        public GZIPFilterStreamContext(OutputStream outputStream) throws IOException {
            this.filterStream = new GZIPOutputStream(outputStream);
        }

        @Override
        public void finalizeContext() throws IOException {
            ((GZIPOutputStream)this.filterStream).finish();
        }
    }
}

