/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.lib.io.fs.FilterStreamContext;
import com.google.common.collect.Maps;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface FilterStreamProvider<F extends FilterOutputStream, S extends OutputStream> {
    public FilterStreamContext<F> getFilterStreamContext(S var1) throws IOException;

    public void reclaimFilterStreamContext(FilterStreamContext<F> var1);

    public static class FilterChainStreamProvider<F extends FilterOutputStream, S extends OutputStream>
    implements FilterStreamProvider<F, S> {
        private List<FilterStreamProvider<?, ?>> streamProviders = new ArrayList();

        public Collection<FilterStreamProvider<?, ?>> getStreamProviders() {
            return Collections.unmodifiableList(this.streamProviders);
        }

        public void addStreamProvider(FilterStreamProvider<?, ?> streamProvider) {
            this.streamProviders.add(streamProvider);
        }

        @Override
        public FilterStreamContext<F> getFilterStreamContext(S outputStream) throws IOException {
            FilterChainStreamContext filterStreamContext = new FilterChainStreamContext();
            Object currOutputStream = outputStream;
            for (int i = this.streamProviders.size() - 1; i >= 0; --i) {
                FilterStreamProvider<?, ?> streamProvider = this.streamProviders.get(i);
                FilterStreamContext<?> streamContext = streamProvider.getFilterStreamContext(currOutputStream);
                filterStreamContext.pushStreamContext(streamContext);
                currOutputStream = streamContext.getFilterStream();
            }
            return filterStreamContext;
        }

        @Override
        public void reclaimFilterStreamContext(FilterStreamContext<F> filterStreamContext) {
            FilterChainStreamContext filterChainContext = (FilterChainStreamContext)filterStreamContext;
            Collection<FilterStreamContext<?>> streamContexts = filterChainContext.getStreamContexts();
            Iterator<FilterStreamContext<?>> iterator = streamContexts.iterator();
            for (FilterStreamProvider<?, ?> streamProvider : this.streamProviders) {
                if (!iterator.hasNext()) continue;
                streamProvider.reclaimFilterStreamContext(iterator.next());
            }
        }

        private class FilterChainStreamContext
        extends FilterStreamContext.BaseFilterStreamContext
        implements FilterStreamContext {
            private List<FilterStreamContext<?>> streamContexts = new ArrayList();

            private FilterChainStreamContext() {
            }

            public void pushStreamContext(FilterStreamContext<?> streamContext) {
                this.streamContexts.add(0, streamContext);
                this.filterStream = streamContext.getFilterStream();
            }

            public Collection<FilterStreamContext<?>> getStreamContexts() {
                return Collections.unmodifiableCollection(this.streamContexts);
            }

            @Override
            public void finalizeContext() throws IOException {
                for (FilterStreamContext<?> streamContext : this.streamContexts) {
                    streamContext.finalizeContext();
                }
            }
        }
    }

    public static abstract class SimpleFilterReusableStreamProvider<F extends FilterOutputStream, S extends OutputStream>
    implements FilterStreamProvider<F, S> {
        private transient Map<OutputStream, FilterStreamContext<F>> reusableContexts = Maps.newHashMap();
        private transient Map<FilterStreamContext<F>, OutputStream> allocatedContexts = Maps.newHashMap();

        @Override
        public FilterStreamContext<F> getFilterStreamContext(S outputStream) throws IOException {
            FilterStreamContext<F> streamContext = this.reusableContexts.remove(outputStream);
            if (streamContext == null) {
                streamContext = this.createFilterStreamContext((OutputStream)outputStream);
            }
            this.allocatedContexts.put(streamContext, (OutputStream)outputStream);
            return streamContext;
        }

        @Override
        public void reclaimFilterStreamContext(FilterStreamContext<F> filterStreamContext) {
            OutputStream outputStream = this.allocatedContexts.remove(filterStreamContext);
            if (outputStream != null) {
                this.reusableContexts.put(outputStream, filterStreamContext);
            }
        }

        protected abstract FilterStreamContext<F> createFilterStreamContext(OutputStream var1) throws IOException;
    }
}

