/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.api.Module;
import com.datatorrent.api.Operator;
import com.datatorrent.lib.io.block.AbstractBlockReader;
import com.datatorrent.lib.io.block.BlockMetadata;
import com.datatorrent.lib.io.block.BlockWriter;
import com.datatorrent.lib.io.fs.AbstractFileSplitter;
import com.datatorrent.lib.io.fs.HDFSFileMerger;
import com.datatorrent.lib.io.fs.Synchronizer;
import com.datatorrent.netlet.util.Slice;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceStability.Evolving
public class HDFSFileCopyModule
implements Module {
    @NotNull
    protected String outputDirectoryPath;
    private boolean overwriteOnConflict = true;
    private String blocksDirectory = "blocks";
    public final transient Module.ProxyInputPort<AbstractFileSplitter.FileMetadata> filesMetadataInput = new Module.ProxyInputPort();
    public final transient Module.ProxyInputPort<BlockMetadata.FileBlockMetadata> blocksMetadataInput = new Module.ProxyInputPort();
    public final transient Module.ProxyInputPort<AbstractBlockReader.ReaderRecord<Slice>> blockData = new Module.ProxyInputPort();

    public void populateDAG(DAG dag, Configuration conf) {
        BlockWriter blockWriter = (BlockWriter)dag.addOperator("BlockWriter", (Operator)new BlockWriter());
        Synchronizer synchronizer = (Synchronizer)dag.addOperator("BlockSynchronizer", (Operator)new Synchronizer());
        dag.setInputPortAttribute((Operator.InputPort)blockWriter.input, Context.PortContext.PARTITION_PARALLEL, (Object)true);
        dag.setInputPortAttribute(blockWriter.blockMetadataInput, Context.PortContext.PARTITION_PARALLEL, (Object)true);
        dag.addStream("CompletedBlockmetadata", blockWriter.blockMetadataOutput, synchronizer.blocksMetadataInput);
        HDFSFileMerger merger = new HDFSFileMerger();
        merger = (HDFSFileMerger)dag.addOperator("FileMerger", (Operator)merger);
        dag.addStream("MergeTrigger", synchronizer.trigger, (Operator.InputPort)merger.input);
        merger.setFilePath(this.outputDirectoryPath);
        merger.setOverwriteOnConflict(this.overwriteOnConflict);
        blockWriter.setBlocksDirectory(this.blocksDirectory);
        merger.setBlocksDirectory(this.blocksDirectory);
        this.filesMetadataInput.set(synchronizer.filesMetadataInput);
        this.blocksMetadataInput.set(blockWriter.blockMetadataInput);
        this.blockData.set((Operator.InputPort)blockWriter.input);
    }

    public String getOutputDirectoryPath() {
        return this.outputDirectoryPath;
    }

    public void setOutputDirectoryPath(String outputDirectoryPath) {
        this.outputDirectoryPath = outputDirectoryPath;
    }

    public boolean isOverwriteOnConflict() {
        return this.overwriteOnConflict;
    }

    public void setOverwriteOnConflict(boolean overwriteOnConflict) {
        this.overwriteOnConflict = overwriteOnConflict;
    }

    public String getBlocksDirectory() {
        return this.blocksDirectory;
    }

    public void setBlocksDirectory(String blocksDirectory) {
        this.blocksDirectory = blocksDirectory;
    }
}

