/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.fs;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.InputOperator;
import com.datatorrent.api.Operator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class TailFsInputOperator
implements InputOperator,
Operator.ActivationListener<Context.OperatorContext> {
    private String filePath;
    private long position;
    private long delay = 10L;
    private int numberOfTuples = 1000;
    private boolean end;
    private char delimiter = (char)10;
    private transient long accessTime;
    private transient RandomAccessFile reader;
    private transient File file;
    public final transient DefaultOutputPort<String> output = new DefaultOutputPort();
    private static final Logger logger = LoggerFactory.getLogger(TailFsInputOperator.class);

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public boolean isEnd() {
        return this.end;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public int getNumberOfTuples() {
        return this.numberOfTuples;
    }

    public void setNumberOfTuples(int numberOfTuples) {
        this.numberOfTuples = numberOfTuples;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void beginWindow(long windowId) {
    }

    public void endWindow() {
        try {
            this.position = this.reader.getFilePointer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setup(Context.OperatorContext context) {
    }

    public void teardown() {
    }

    public void activate(Context.OperatorContext ctx) {
        try {
            this.file = new File(this.filePath);
            this.reader = new RandomAccessFile(this.file, "r");
            this.position = this.end ? this.file.length() : this.position;
            this.reader.seek(this.position);
            this.accessTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deactivate() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.position = 0L;
    }

    public void emitTuples() {
        try {
            for (int localCounter = this.numberOfTuples; localCounter >= 0; --localCounter) {
                String str = this.readLine();
                if (str != null) {
                    this.output.emit((Object)str);
                }
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readLine() throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        long pos = this.reader.getFilePointer();
        long length = this.file.length();
        if (length < pos || length == pos && FileUtils.isFileNewer((File)this.file, (long)this.accessTime)) {
            this.reader.close();
            this.reader = new RandomAccessFile(this.file, "r");
            this.position = 0L;
            this.reader.seek(this.position);
            pos = 0L;
        }
        this.accessTime = System.currentTimeMillis();
        while ((ch = this.reader.read()) != -1) {
            char readChar = (char)ch;
            if (readChar != this.delimiter) {
                sb.append(readChar);
                continue;
            }
            return sb.toString();
        }
        this.reader.seek(pos);
        return null;
    }
}

