/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.jms;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class JMSBase {
    private static final Logger logger = LoggerFactory.getLogger(JMSBase.class);
    private transient Connection connection;
    private transient Session session;
    private transient Destination destination;
    private String connectionFactoryClass;
    private Map<String, String> connectionFactoryProperties = Maps.newHashMap();
    private String ackMode = "CLIENT_ACKNOWLEDGE";
    private String clientId = "TestClient";
    private String subject = "TEST.FOO";
    private int batch = 10;
    private int messageSize = 255;
    private boolean durable = false;
    private boolean topic = false;
    private boolean verbose = false;
    protected boolean transacted = true;

    public Connection getConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public String getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.connectionFactoryClass = connectionFactoryClass;
    }

    public Map<String, String> getConnectionFactoryProperties() {
        return this.connectionFactoryProperties;
    }

    public void setConnectionFactoryProperties(Map<String, String> connectionFactoryProperties) {
        this.connectionFactoryProperties = connectionFactoryProperties;
    }

    @Deprecated
    public void setUser(String user) {
        this.connectionFactoryProperties.put("userName", user);
    }

    @Deprecated
    public void setPassword(String password) {
        this.connectionFactoryProperties.put("password", password);
    }

    @Deprecated
    public void setUrl(String url) {
        this.connectionFactoryProperties.put("brokerURL", url);
    }

    public String getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(String ackMode) {
        this.ackMode = ackMode;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public int getBatch() {
        return this.batch;
    }

    public void setBatch(int batch) {
        this.batch = batch;
    }

    public int getMessageSize() {
        return this.messageSize;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isTopic() {
        return this.topic;
    }

    public void setTopic(boolean topic) {
        this.topic = topic;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getSessionAckMode(String ackMode) {
        if ("CLIENT_ACKNOWLEDGE".equals(ackMode)) {
            return 2;
        }
        if ("AUTO_ACKNOWLEDGE".equals(ackMode)) {
            return 1;
        }
        if ("DUPS_OK_ACKNOWLEDGE".equals(ackMode)) {
            return 3;
        }
        if ("SESSION_TRANSACTED".equals(ackMode)) {
            return 0;
        }
        return 2;
    }

    public void createConnection() throws JMSException {
        this.connection = this.getConnectionFactory().createConnection();
        if (this.durable && this.clientId != null) {
            this.connection.setClientID(this.clientId);
        }
        logger.debug("Before starting connection.");
        this.connection.start();
        logger.debug("After starting connection.");
        this.session = this.connection.createSession(this.transacted, this.getSessionAckMode(this.ackMode));
        this.destination = this.topic ? this.session.createTopic(this.subject) : this.session.createQueue(this.subject);
    }

    protected ConnectionFactory getConnectionFactory() {
        logger.debug("class {} properties {}", (Object)this.connectionFactoryClass, this.connectionFactoryProperties);
        try {
            ActiveMQConnectionFactory cf;
            if (this.connectionFactoryClass != null) {
                Class<?> clazz = Class.forName(this.connectionFactoryClass);
                cf = (ConnectionFactory)clazz.newInstance();
            } else {
                cf = new ActiveMQConnectionFactory();
            }
            BeanUtils.populate((Object)cf, this.connectionFactoryProperties);
            logger.debug("creation successful.");
            return cf;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create connection factory.", e);
        }
    }

    protected void cleanup() {
        try {
            this.session.close();
            this.connection.close();
            this.session = null;
            this.connection = null;
        }
        catch (JMSException ex) {
            logger.debug(ex.getLocalizedMessage());
        }
    }

    public boolean isTransacted() {
        return this.transacted;
    }
}

