/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.jms;

import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.annotation.InputPortFieldAnnotation;
import com.datatorrent.lib.io.jms.AbstractJMSOutputOperator;
import java.io.Serializable;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class JMSMultiPortOutputOperator
extends AbstractJMSOutputOperator {
    @InputPortFieldAnnotation(optional=true)
    public final transient DefaultInputPort<Map<?, ?>> inputMapPort = new DefaultInputPort<Map<?, ?>>(){

        public void process(Map<?, ?> tuple) {
            JMSMultiPortOutputOperator.this.sendMessage(tuple);
        }
    };
    @InputPortFieldAnnotation(optional=true)
    public final transient DefaultInputPort<byte[]> inputByteArrayPort = new DefaultInputPort<byte[]>(){

        public void process(byte[] tuple) {
            JMSMultiPortOutputOperator.this.sendMessage(tuple);
        }
    };
    @InputPortFieldAnnotation(optional=true)
    public final transient DefaultInputPort<Serializable> inputObjectPort = new DefaultInputPort<Serializable>(){

        public void process(Serializable tuple) {
            JMSMultiPortOutputOperator.this.sendMessage(tuple);
        }
    };
    @InputPortFieldAnnotation(optional=true)
    public final transient DefaultInputPort<String> inputStringTypePort = new DefaultInputPort<String>(){

        public void process(String tuple) {
            JMSMultiPortOutputOperator.this.sendMessage(tuple);
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(JMSMultiPortOutputOperator.class);

    protected void processTuple(Object tuple) {
        this.sendMessage(tuple);
    }

    @Override
    protected Message createMessage(Object tuple) {
        try {
            if (tuple instanceof Message) {
                return (Message)tuple;
            }
            if (tuple instanceof String) {
                return this.getSession().createTextMessage((String)tuple);
            }
            if (tuple instanceof byte[]) {
                BytesMessage message = this.getSession().createBytesMessage();
                message.writeBytes((byte[])tuple);
                return message;
            }
            if (tuple instanceof Map) {
                return this.createMessageForMap((Map)tuple);
            }
            if (tuple instanceof Serializable) {
                return this.getSession().createObjectMessage((Serializable)tuple);
            }
            throw new RuntimeException("Cannot convert object of type " + tuple.getClass() + "] to JMS message. Supported message " + "payloads are: String, byte array, Map<String,?>, Serializable object.");
        }
        catch (JMSException ex) {
            logger.error(ex.getLocalizedMessage());
            throw new RuntimeException(ex);
        }
    }

    private Message createMessageForMap(Map<?, ?> map) throws JMSException {
        MapMessage message = this.getSession().createMapMessage();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new RuntimeException("Cannot convert non-String key of type [" + entry.getKey().getClass() + "] to JMS MapMessage entry");
            }
            message.setObject((String)entry.getKey(), entry.getValue());
        }
        return message;
    }
}

