/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.io.jms;

import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.lib.io.jms.AbstractJMSInputOperator;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class JMSObjectInputOperator
extends AbstractJMSInputOperator<Object> {
    public final transient DefaultOutputPort<String> outputString = new DefaultOutputPort();
    public final transient DefaultOutputPort<byte[]> outputBytes = new DefaultOutputPort();
    public final transient DefaultOutputPort<Map<String, Object>> outputMap = new DefaultOutputPort();
    private static final transient Logger logger = LoggerFactory.getLogger(JMSObjectInputOperator.class);

    @Override
    public Object convert(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText();
        }
        if (message instanceof StreamMessage) {
            return ((StreamMessage)message).readString();
        }
        if (message instanceof BytesMessage) {
            return this.extractByteArrayFromMessage((BytesMessage)message);
        }
        if (message instanceof MapMessage) {
            return this.extractMapFromMessage((MapMessage)message);
        }
        if (message instanceof ObjectMessage) {
            return this.extractSerializableFromMessage((ObjectMessage)message);
        }
        return message;
    }

    protected byte[] extractByteArrayFromMessage(BytesMessage message) throws JMSException {
        byte[] bytes = new byte[(int)message.getBodyLength()];
        message.readBytes(bytes);
        return bytes;
    }

    protected Map<String, Object> extractMapFromMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration en = message.getMapNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            map.put(key, message.getObject(key));
        }
        return map;
    }

    protected Serializable extractSerializableFromMessage(ObjectMessage message) throws JMSException {
        return message.getObject();
    }

    @Override
    protected void emit(Object payload) {
        if (this.outputString.isConnected()) {
            this.outputString.emit((Object)((String)payload));
        } else if (this.outputMap.isConnected()) {
            this.outputMap.emit((Object)((Map)payload));
        } else if (this.outputBytes.isConnected()) {
            this.outputBytes.emit((Object)((byte[])payload));
        } else {
            this.output.emit(payload);
        }
    }
}

