/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.join;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.api.annotation.OperatorAnnotation;
import com.datatorrent.lib.streamquery.condition.Condition;
import com.datatorrent.lib.streamquery.index.Index;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;

@OperatorAnnotation(partitionable=false)
@InterfaceStability.Evolving
public class AntiJoinOperator
implements Operator {
    private Condition joinCondition;
    private ArrayList<Index> table1Columns = new ArrayList();
    private List<Map<String, Object>> table1;
    private List<Map<String, Object>> table2;
    public final transient DefaultInputPort<Map<String, Object>> inport1 = new DefaultInputPort<Map<String, Object>>(){

        public void process(Map<String, Object> tuple) {
            AntiJoinOperator.this.table1.add(tuple);
            for (int j = 0; j < AntiJoinOperator.this.table2.size(); ++j) {
                if (AntiJoinOperator.this.joinCondition == null || !AntiJoinOperator.this.joinCondition.isValidJoin(tuple, (Map)AntiJoinOperator.this.table2.get(j))) continue;
                AntiJoinOperator.this.table1.remove(tuple);
            }
        }
    };
    public final transient DefaultInputPort<Map<String, Object>> inport2 = new DefaultInputPort<Map<String, Object>>(){

        public void process(Map<String, Object> tuple) {
            AntiJoinOperator.this.table2.add(tuple);
            for (int j = 0; j < AntiJoinOperator.this.table1.size(); ++j) {
                if (AntiJoinOperator.this.joinCondition == null || !AntiJoinOperator.this.joinCondition.isValidJoin((Map)AntiJoinOperator.this.table1.get(j), tuple)) continue;
                AntiJoinOperator.this.table1.remove(AntiJoinOperator.this.table1.get(j));
            }
        }
    };
    public final transient DefaultOutputPort<Map<String, Object>> outport = new DefaultOutputPort();

    public void setup(Context.OperatorContext arg0) {
        this.table1 = new ArrayList<Map<String, Object>>();
        this.table2 = new ArrayList<Map<String, Object>>();
    }

    public void teardown() {
    }

    public void beginWindow(long arg0) {
    }

    public void endWindow() {
        for (int i = 0; i < this.table1.size(); ++i) {
            this.joinRows(this.table1.get(i));
        }
        this.table1.clear();
        this.table2.clear();
    }

    public Condition getJoinCondition() {
        return this.joinCondition;
    }

    public void setJoinCondition(Condition joinCondition) {
        this.joinCondition = joinCondition;
    }

    public void selectTable1Column(Index column) {
        this.table1Columns.add(column);
    }

    protected void joinRows(Map<String, Object> row) {
        HashMap<String, Object> join = new HashMap<String, Object>();
        if (row != null) {
            for (Index index : this.table1Columns) {
                index.filter(row, join);
            }
        }
        this.outport.emit(join);
    }
}

