/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.lib.join;

import com.datatorrent.lib.join.AbstractJoinOperator;
import com.datatorrent.lib.util.PojoUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Unstable
public class POJOJoinOperator
extends AbstractJoinOperator {
    protected Class outputClass;
    protected transient Class leftClass;
    protected transient Class rightClass;
    private String outputClassStr;
    private transient List<FieldObjectMap>[] fieldMap = (List[])Array.newInstance(new LinkedList().getClass(), 2);
    private transient PojoUtils.Getter[] keyGetters = (PojoUtils.Getter[])Array.newInstance(PojoUtils.Getter.class, 2);
    private transient PojoUtils.Getter[] timeGetters = (PojoUtils.Getter[])Array.newInstance(PojoUtils.Getter.class, 2);

    protected void processTuple(Object tuple) {
        this.setAndPopulateGetters(tuple, this.isLeft);
        super.processTuple(tuple);
    }

    private void setAndPopulateGetters(Object tuple, boolean isLeft) {
        if (isLeft && this.leftClass == null) {
            this.leftClass = tuple.getClass();
            this.populateGettersFromInput(isLeft);
        }
        if (!isLeft && this.rightClass == null) {
            this.rightClass = tuple.getClass();
            this.populateGettersFromInput(isLeft);
        }
    }

    private void populateGettersFromInput(boolean isLeft) {
        Class c;
        AbstractJoinOperator.StoreContext store;
        Class inputClass;
        int idx;
        if (isLeft) {
            idx = 0;
            inputClass = this.leftClass;
            store = this.leftStore;
        } else {
            idx = 1;
            inputClass = this.rightClass;
            store = this.rightStore;
        }
        String key = store.getKeys();
        String timeField = store.getTimeFields();
        String[] fields = store.getIncludeFields();
        try {
            c = ClassUtils.primitiveToWrapper(inputClass.getField(key).getType());
            this.keyGetters[idx] = PojoUtils.createGetter(inputClass, key, c);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (timeField != null) {
            try {
                c = ClassUtils.primitiveToWrapper(inputClass.getField(timeField).getType());
                this.timeGetters[idx] = PojoUtils.createGetter(inputClass, timeField, c);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        this.fieldMap[idx] = new LinkedList<FieldObjectMap>();
        List<FieldObjectMap> fieldsMap = this.fieldMap[idx];
        for (String f : fields) {
            try {
                Field field = inputClass.getField(f);
                Class c2 = field.getType().isPrimitive() ? ClassUtils.primitiveToWrapper(field.getType()) : field.getType();
                FieldObjectMap fm = new FieldObjectMap();
                fm.get = PojoUtils.createGetter(inputClass, f, c2);
                fm.set = PojoUtils.createSetter(this.outputClass, f, c2);
                fieldsMap.add(fm);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to populate gettter for field: " + f, e);
            }
        }
    }

    protected Object createOutputTuple() {
        try {
            return this.outputClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void copyValue(Object output, Object extractTuple, boolean isLeft) {
        if (extractTuple == null) {
            return;
        }
        this.setAndPopulateGetters(extractTuple, isLeft);
        List<FieldObjectMap> fieldsMap = isLeft ? this.fieldMap[0] : this.fieldMap[1];
        for (FieldObjectMap map : fieldsMap) {
            map.set.set(output, map.get.get(extractTuple));
        }
    }

    @Override
    public Object getKeyValue(String keyField, Object tuple) {
        if (this.isLeft) {
            return this.keyGetters[0].get(tuple);
        }
        return this.keyGetters[1].get(tuple);
    }

    @Override
    protected Object getTime(String field, Object tuple) {
        if (this.getTimeFieldStr() != null) {
            if (this.isLeft) {
                return this.timeGetters[0].get(tuple);
            }
            return this.timeGetters[1].get(tuple);
        }
        return Calendar.getInstance().getTimeInMillis();
    }

    public void populateOutputClass() {
        try {
            this.outputClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.outputClassStr);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getOutputClass() {
        return this.outputClassStr;
    }

    public void setOutputClass(String outputClassStr) {
        this.outputClassStr = outputClassStr;
        this.populateOutputClass();
    }

    private class FieldObjectMap {
        public PojoUtils.Getter get;
        public PojoUtils.Setter set;

        private FieldObjectMap() {
        }
    }
}

